/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry.recipes;

import com.google.common.collect.ImmutableMap;
import forestry.api.recipes.ICentrifugeRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class CentrifugeRecipe
implements ICentrifugeRecipe {
    private final int processingTime;
    private final ItemStack input;
    private final Map<ItemStack, Float> outputs;

    public CentrifugeRecipe(int processingTime, ItemStack input, Map<ItemStack, Float> outputs) {
        this.processingTime = processingTime;
        this.input = input;
        this.outputs = outputs;
        for (ItemStack item : outputs.keySet()) {
            if (item != null) continue;
            throw new IllegalArgumentException("Tried to register a null product of " + input);
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public Collection<ItemStack> getProducts(Random random) {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Float> entry : this.outputs.entrySet()) {
            float probability = entry.getValue().floatValue();
            if ((double)probability >= 1.0) {
                products.add(entry.getKey().func_77946_l());
                continue;
            }
            if (!(random.nextFloat() < probability)) continue;
            products.add(entry.getKey().func_77946_l());
        }
        return products;
    }

    public Map<ItemStack, Float> getAllProducts() {
        return ImmutableMap.copyOf(this.outputs);
    }
}

