/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseMapAddition;
import com.blamejared.mtlib.utils.BaseMapRemoval;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IFermenterManager;
import forestry.api.recipes.IFermenterRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.jei.fermenter.FermenterRecipeWrapper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker.mods.forestry.ForestryListAddition;
import modtweaker.mods.forestry.ForestryListRemoval;
import modtweaker.mods.forestry.recipes.FermenterRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Fermenter")
public class Fermenter {
    public static final String name = "Forestry Fermenter";
    public static final String nameFuel = "Forestry Fermenter (Fuel)";

    @ZenMethod
    public static void addRecipe(ILiquidStack fluidOutput, IItemStack resource, ILiquidStack fluidInput, int fermentationValue, float fluidOutputModifier) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new FermenterRecipe(InputHelper.toStack((IItemStack)resource), fermentationValue, fluidOutputModifier, InputHelper.getFluid((ILiquidStack)fluidOutput), InputHelper.toFluid((ILiquidStack)fluidInput))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<IFermenterRecipe> recipes = new LinkedList<IFermenterRecipe>();
        for (IFermenterRecipe recipe : RecipeManagers.fermenterManager.recipes()) {
            if (recipe != null && recipe.getResource() != null && StackHelper.matches((IIngredient)input, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.getResource()))) {
                recipes.add(recipe);
            }
            if (recipe == null || recipe.getResource() == null || !StackHelper.matches((IIngredient)input, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)recipe.getFluidResource()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, input.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(IItemStack item, int fermentPerCycle, int burnDuration) {
        MineTweakerAPI.apply((IUndoableAction)new AddFuel(new FermenterFuel(InputHelper.toStack((IItemStack)item), fermentPerCycle, burnDuration)));
    }

    @ZenMethod
    public static void removeFuel(IIngredient fermenterItem) {
        HashMap<ItemStack, FermenterFuel> fuelItems = new HashMap<ItemStack, FermenterFuel>();
        for (Map.Entry fuelItem : FuelManager.fermenterFuel.entrySet()) {
            if (fuelItem == null || !StackHelper.matches((IIngredient)fermenterItem, (IItemStack)InputHelper.toIItemStack((ItemStack)((FermenterFuel)fuelItem.getValue()).getItem()))) continue;
            fuelItems.put((ItemStack)fuelItem.getKey(), (FermenterFuel)fuelItem.getValue());
        }
        if (!fuelItems.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(fuelItems));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, fermenterItem.toString()));
        }
    }

    private static class RemoveFuel
    extends BaseMapRemoval<ItemStack, FermenterFuel> {
        public RemoveFuel(Map<ItemStack, FermenterFuel> recipes) {
            super(Fermenter.nameFuel, FuelManager.fermenterFuel, recipes);
        }

        public String getRecipeInfo(Map.Entry<ItemStack, FermenterFuel> fuelEntry) {
            return LogHelper.getStackDescription((Object)fuelEntry.getKey());
        }
    }

    private static class AddFuel
    extends BaseMapAddition<ItemStack, FermenterFuel> {
        public AddFuel(FermenterFuel fuelEntry) {
            super(Fermenter.nameFuel, FuelManager.fermenterFuel);
            this.recipes.put(fuelEntry.getItem(), fuelEntry);
        }

        public String getRecipeInfo(Map.Entry<ItemStack, FermenterFuel> fuelEntry) {
            return LogHelper.getStackDescription((Object)fuelEntry.getKey());
        }
    }

    private static class Remove
    extends ForestryListRemoval<IFermenterRecipe, IFermenterManager> {
        public Remove(List<IFermenterRecipe> recipes) {
            super(Fermenter.name, RecipeManagers.fermenterManager, recipes);
        }

        @Override
        protected String getRecipeInfo(IFermenterRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutput());
        }

        @Override
        public IRecipeWrapper wrapRecipe(IFermenterRecipe recipe) {
            return new FermenterRecipeWrapper(recipe, recipe.getResource());
        }
    }

    private static class Add
    extends ForestryListAddition<IFermenterRecipe> {
        public Add(IFermenterRecipe recipe) {
            super(Fermenter.name, (ICraftingProvider)RecipeManagers.fermenterManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IFermenterRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutput());
        }

        @Override
        public IRecipeWrapper wrapRecipe(IFermenterRecipe recipe) {
            return new FermenterRecipeWrapper(recipe, recipe.getResource());
        }
    }
}

