/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import forestry.api.recipes.ICentrifugeManager;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.recipes.jei.centrifuge.CentrifugeRecipeWrapper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.WeightedItemStack;
import modtweaker.mods.forestry.ForestryListAddition;
import modtweaker.mods.forestry.ForestryListRemoval;
import modtweaker.mods.forestry.recipes.CentrifugeRecipe;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Centrifuge")
public class Centrifuge {
    public static final String name = "Forestry Centrifuge";

    @ZenMethod
    public static void addRecipe(WeightedItemStack[] output, IItemStack ingredients, int packagingTime) {
        HashMap<ItemStack, Float> products = new HashMap<ItemStack, Float>();
        for (WeightedItemStack product : output) {
            products.put(InputHelper.toStack((IItemStack)product.getStack()), Float.valueOf(product.getChance()));
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new CentrifugeRecipe(packagingTime, InputHelper.toStack((IItemStack)ingredients), products)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        LinkedList<ICentrifugeRecipe> recipes = new LinkedList<ICentrifugeRecipe>();
        for (ICentrifugeRecipe recipe : RecipeManagers.centrifugeManager.recipes()) {
            if (recipe == null || !StackHelper.matches((IIngredient)input, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.getInput()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, input.toString()));
        }
    }

    private static class Remove
    extends ForestryListRemoval<ICentrifugeRecipe, ICentrifugeManager> {
        public Remove(List<ICentrifugeRecipe> recipes) {
            super(Centrifuge.name, RecipeManagers.centrifugeManager, recipes);
        }

        @Override
        protected String getRecipeInfo(ICentrifugeRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getInput());
        }

        @Override
        public IRecipeWrapper wrapRecipe(ICentrifugeRecipe recipe) {
            return new CentrifugeRecipeWrapper(recipe);
        }
    }

    private static class Add
    extends ForestryListAddition<ICentrifugeRecipe> {
        public Add(ICentrifugeRecipe recipe) {
            super(Centrifuge.name, (ICraftingProvider)RecipeManagers.centrifugeManager);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(ICentrifugeRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getInput());
        }

        @Override
        public IRecipeWrapper wrapRecipe(ICentrifugeRecipe recipe) {
            return new CentrifugeRecipeWrapper(recipe);
        }
    }
}

