/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.forestry.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import forestry.api.recipes.ICarpenterManager;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IDescriptiveRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.factory.recipes.jei.carpenter.CarpenterRecipeWrapper;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker.mods.forestry.ForestryListAddition;
import modtweaker.mods.forestry.ForestryListRemoval;
import modtweaker.mods.forestry.recipes.CarpenterRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Carpenter")
public class Carpenter {
    public static final String name = "Forestry Carpenter";

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[][] ingredients, int packagingTime, @Optional ILiquidStack fluidInput, @Optional IItemStack box) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new CarpenterRecipe(packagingTime, InputHelper.toFluid((ILiquidStack)fluidInput), InputHelper.toStack((IItemStack)box), (IDescriptiveRecipe)new ShapedRecipeCustom(InputHelper.toStack((IItemStack)output), InputHelper.toShapedObjects((IIngredient[][])ingredients)))));
    }

    private static IItemStack[][] transform(IItemStack[] arr, int N) {
        int M = (arr.length + N - 1) / N;
        IItemStack[][] mat = new IItemStack[M][];
        int start = 0;
        for (int r = 0; r < M; ++r) {
            int L = Math.min(N, arr.length - start);
            mat[r] = Arrays.copyOfRange(arr, start, start + L);
            start += L;
        }
        return mat;
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output, @Optional IIngredient fluidInput) {
        LinkedList<ICarpenterRecipe> recipes = new LinkedList<ICarpenterRecipe>();
        for (ICarpenterRecipe recipe : RecipeManagers.carpenterManager.recipes()) {
            ItemStack recipeResult;
            if (recipe == null || (recipeResult = recipe.getCraftingGridRecipe().func_77571_b()) == null || !StackHelper.matches((IIngredient)output, (IItemStack)InputHelper.toIItemStack((ItemStack)recipeResult))) continue;
            if (fluidInput != null) {
                if (!StackHelper.matches((IIngredient)fluidInput, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)recipe.getFluidResource()))) continue;
                recipes.add(recipe);
                continue;
            }
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends ForestryListRemoval<ICarpenterRecipe, ICarpenterManager> {
        public Remove(List<ICarpenterRecipe> recipes) {
            super(Carpenter.name, RecipeManagers.carpenterManager, recipes);
        }

        @Override
        public void apply() {
            super.apply();
        }

        @Override
        protected String getRecipeInfo(ICarpenterRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getCraftingGridRecipe().func_77571_b());
        }

        @Override
        public IRecipeWrapper wrapRecipe(ICarpenterRecipe recipe) {
            return new CarpenterRecipeWrapper(recipe);
        }
    }

    private static class Add
    extends ForestryListAddition<ICarpenterRecipe> {
        public Add(ICarpenterRecipe recipe) {
            super(Carpenter.name, (ICraftingProvider)RecipeManagers.carpenterManager);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(ICarpenterRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getCraftingGridRecipe().func_77571_b());
        }

        @Override
        public IRecipeWrapper wrapRecipe(ICarpenterRecipe recipe) {
            return new CarpenterRecipeWrapper(recipe);
        }
    }
}

