/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.botania.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

@ZenClass(value="mods.botania.Apothecary")
public class Apothecary {
    protected static final String name = "Botania Petal";

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] input) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipePetals(InputHelper.toStack((IItemStack)output), InputHelper.toObjects((IIngredient[])input))));
    }

    @ZenMethod
    public static void addRecipe(String output, IIngredient[] input) {
        Apothecary.addRecipe(InputHelper.toIItemStack((ItemStack)ItemBlockSpecialFlower.ofType((String)output)), input);
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<RecipePetals> result = new LinkedList<RecipePetals>();
        for (RecipePetals entry : BotaniaAPI.petalRecipes) {
            if (entry == null || entry.getOutput() == null || !StackHelper.matches((IIngredient)output, (IItemStack)InputHelper.toIItemStack((ItemStack)entry.getOutput()))) continue;
            result.add(entry);
        }
        if (!result.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(result));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    @ZenMethod
    public static void removeRecipe(String output) {
        Apothecary.removeRecipe((IIngredient)InputHelper.toIItemStack((ItemStack)ItemBlockSpecialFlower.ofType((String)output)));
    }

    private static class Remove
    extends BaseListRemoval<RecipePetals> {
        public Remove(List<RecipePetals> recipes) {
            super(Apothecary.name, BotaniaAPI.petalRecipes, recipes);
        }

        public String getRecipeInfo(RecipePetals recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutput());
        }
    }

    private static class Add
    extends BaseListAddition<RecipePetals> {
        public Add(RecipePetals recipe) {
            super(Apothecary.name, BotaniaAPI.petalRecipes);
            this.recipes.add(recipe);
        }

        public String getRecipeInfo(RecipePetals recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutput());
        }
    }
}

