/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.bloodmagic.handlers;

import WayofTime.bloodmagic.api.recipe.AlchemyTableRecipe;
import WayofTime.bloodmagic.compat.jei.alchemyTable.AlchemyTableRecipeJEI;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker.mods.bloodmagic.BloodMagicHelper;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.AlchemyTable")
public class AlchemyTable {
    protected static final String name = "Blood Magic Alchemy Table";

    @ZenMethod
    public static void addRecipe(IItemStack output, int lpDrained, int ticksRequired, int tierRequired, IIngredient[] input) {
        if (output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (lpDrained < 0) {
            LogHelper.logWarning((String)String.format("LP drained can't be below 0 (%d) for %s Recipe", lpDrained, name));
            return;
        }
        if (ticksRequired < 0) {
            LogHelper.logWarning((String)String.format("Ticks required can't be below 0 (%d) for %s Recipe", ticksRequired, name));
            return;
        }
        if (tierRequired < 1) {
            LogHelper.logWarning((String)String.format("Tier required can't be below 1 (%d) for %s Recipe", tierRequired, name));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new AlchemyTableRecipe(InputHelper.toStack((IItemStack)output), lpDrained, ticksRequired, tierRequired, InputHelper.toObjects((IIngredient[])input)), BloodMagicHelper.alchemyTableList));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        AlchemyTable.remove(output, BloodMagicHelper.alchemyTableList);
    }

    public static void remove(IIngredient output, List<AlchemyTableRecipe> list) {
        if (output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        LinkedList<AlchemyTableRecipe> recipes = new LinkedList<AlchemyTableRecipe>();
        for (AlchemyTableRecipe recipe : list) {
            if (!StackHelper.matches((IIngredient)output, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.getRecipeOutput(null)))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(list, recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<AlchemyTableRecipe> {
        public Remove(List<AlchemyTableRecipe> list, List<AlchemyTableRecipe> recipes) {
            super(AlchemyTable.name, list, recipes);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (AlchemyTableRecipe recipe : this.recipes) {
                if (recipe != null) {
                    if (this.list.remove(recipe)) {
                        this.successful.add(recipe);
                        MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new AlchemyTableRecipeJEI(recipe));
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }

        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (AlchemyTableRecipe recipe : this.successful) {
                if (recipe != null) {
                    if (!this.list.add(recipe)) {
                        LogHelper.logError((String)String.format("Error restoring %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                        continue;
                    }
                    MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new AlchemyTableRecipeJEI(recipe));
                    continue;
                }
                LogHelper.logError((String)String.format("Error restoring %s Recipe: null object", this.name));
            }
        }

        protected String getRecipeInfo(AlchemyTableRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getRecipeOutput(null));
        }
    }

    private static class Add
    extends BaseListAddition<AlchemyTableRecipe> {
        public Add(AlchemyTableRecipe recipe, List<AlchemyTableRecipe> list) {
            super(AlchemyTable.name, list);
            this.recipes.add(recipe);
        }

        public void apply() {
            if (this.recipes.isEmpty()) {
                return;
            }
            for (AlchemyTableRecipe recipe : this.recipes) {
                if (recipe != null) {
                    if (this.list.add(recipe)) {
                        this.successful.add(recipe);
                        MineTweakerAPI.getIjeiRecipeRegistry().addRecipe((Object)new AlchemyTableRecipeJEI(recipe));
                        continue;
                    }
                    LogHelper.logError((String)String.format("Error adding %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                    continue;
                }
                LogHelper.logError((String)String.format("Error adding %s Recipe: null object", this.name));
            }
        }

        public void undo() {
            if (this.successful.isEmpty()) {
                return;
            }
            for (AlchemyTableRecipe recipe : this.successful) {
                if (recipe != null) {
                    if (!this.list.remove(recipe)) {
                        LogHelper.logError((String)String.format("Error removing %s Recipe for %s", this.name, this.getRecipeInfo(recipe)));
                        continue;
                    }
                    MineTweakerAPI.getIjeiRecipeRegistry().removeRecipe((Object)new AlchemyTableRecipeJEI(recipe));
                    continue;
                }
                LogHelper.logError((String)String.format("Error removing %s Recipe: null object", this.name));
            }
        }

        public String getRecipeInfo(AlchemyTableRecipe recipe) {
            return LogHelper.getStackDescription((Object)recipe.getRecipeOutput(null));
        }
    }
}

