/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.actuallyadditions.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.actuallyadditions.Coffee")
public class CoffeeMaker {
    protected static final String name = "Actually Additions Coffee Maker";

    @ZenMethod
    public static void addRecipe(IItemStack ingredient, int maxAmplifier, String[] effectStrings, int[] effectDurations) {
        ArrayList<PotionEffect> potionTypeArrayList = new ArrayList<PotionEffect>();
        for (int i = 0; i < effectStrings.length; ++i) {
            potionTypeArrayList.add(new PotionEffect(Potion.func_180142_b((String)effectStrings[i]), effectDurations[i]));
        }
        PotionEffect[] potionTypeArray = new PotionEffect[potionTypeArrayList.size()];
        for (int i = 0; i < potionTypeArrayList.size(); ++i) {
            potionTypeArray[i] = (PotionEffect)potionTypeArrayList.get(i);
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new CoffeeIngredient(InputHelper.toStack((IItemStack)ingredient), potionTypeArray, maxAmplifier)));
    }

    @ZenMethod
    public static void remove(IIngredient input) {
        LinkedList<CoffeeIngredient> recipes = new LinkedList<CoffeeIngredient>();
        if (input == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        for (CoffeeIngredient recipe : ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS) {
            if (!StackHelper.matches((IIngredient)input, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.ingredient))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s. Command ignored!", name, input.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<CoffeeIngredient> {
        public Remove(List<CoffeeIngredient> recipes) {
            super(CoffeeMaker.name, ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS, recipes);
        }

        protected String getRecipeInfo(CoffeeIngredient recipe) {
            return LogHelper.getStackDescription((Object)recipe.ingredient);
        }
    }

    private static class Add
    extends BaseListAddition<CoffeeIngredient> {
        public Add(CoffeeIngredient recipe) {
            super(CoffeeMaker.name, ActuallyAdditionsAPI.COFFEE_MACHINE_INGREDIENTS);
            this.recipes.add(recipe);
        }

        public String getRecipeInfo(CoffeeIngredient recipe) {
            return LogHelper.getStackDescription((Object)recipe.ingredient);
        }
    }
}

