/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.items;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.ModBlocks;
import ganymedes01.headcrumbs.libs.CelebrityMap;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.tileentities.TileEntityBlockSkull;
import ganymedes01.headcrumbs.utils.HeadUtils;
import ganymedes01.headcrumbs.utils.Utils;
import ganymedes01.headcrumbs.utils.helpers.LycanitesHelper;
import ganymedes01.headcrumbs.utils.helpers.LycanitesHelperClient;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Skull
extends ItemSkull {
    public Skull() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(Headcrumbs.tab);
        this.func_77655_b(Utils.getUnlocalisedName("head"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean isComplex) {
        String tip;
        if (!Headcrumbs.enableTooltips) {
            return;
        }
        String name = HeadUtils.getName(stack);
        if (name != null && (tip = CelebrityMap.getTooltip(name)) != null) {
            list.add(tip);
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityBlockSkull tile;
        GameProfile profile;
        if (side == 0) {
            return false;
        }
        if (!world.func_147439_a(x, y, z).func_149688_o().func_76220_a()) {
            return false;
        }
        if (Headcrumbs.enablePlayerStatues && stack.func_77960_j() == SkullTypes.player.ordinal() && this.isValidStructure(world, x, y, z) && (profile = HeadUtils.getGameProfile(stack)) != null) {
            world.func_147465_d(x, y, z, ModBlocks.blockPlayer, 1, 3);
            Utils.doBreakParticles(world, x, y, z, Blocks.field_150425_aM, 0);
            world.func_147449_b(x, y - 1, z, ModBlocks.blockEmpty);
            Utils.doBreakParticles(world, x, y - 1, z, Blocks.field_150425_aM, 0);
            TileEntityBlockSkull tile2 = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBlockSkull.class);
            if (tile2 != null) {
                tile2.setType(stack.func_77960_j(), profile);
                tile2.func_145903_a(MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF);
                world.func_147444_c(x, y, z, ModBlocks.blockPlayer);
            }
            --stack.field_77994_a;
            return true;
        }
        if (side == 1) {
            ++y;
        }
        if (side == 2) {
            --z;
        }
        if (side == 3) {
            ++z;
        }
        if (side == 4) {
            --x;
        }
        if (side == 5) {
            ++x;
        }
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        if (!ModBlocks.blockSkull.func_149742_c(world, x, y, z)) {
            return false;
        }
        world.func_147465_d(x, y, z, ModBlocks.blockSkull, side, 2);
        int angle = 0;
        if (side == 1) {
            angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
        }
        if ((tile = Utils.getTileEntity((IBlockAccess)world, x, y, z, TileEntityBlockSkull.class)) != null) {
            GameProfile profile2 = HeadUtils.getGameProfile(stack);
            tile.setType(stack.func_77960_j(), profile2);
            tile.func_145903_a(angle);
            world.func_147444_c(x, y, z, ModBlocks.blockSkull);
        }
        --stack.field_77994_a;
        return true;
    }

    private boolean isValidStructure(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == Headcrumbs.clay && world.func_147439_a(x, y - 1, z) == Headcrumbs.clay;
    }

    public String func_77667_c(ItemStack stack) {
        SkullTypes type = SkullTypes.values()[Math.max(Math.min(stack.func_77960_j(), SkullTypes.values().length - 1), 0)];
        return "item." + Utils.getUnlocalisedName(type.name());
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (SkullTypes skull : SkullTypes.values()) {
            if (!skull.canShow() || skull == SkullTypes.lycanites) continue;
            if (skull == SkullTypes.player && !Headcrumbs.hidePlayerHeadsFromTab) {
                list.addAll(HeadUtils.players);
                continue;
            }
            list.add(new ItemStack(item, 1, skull.ordinal()));
        }
        if (SkullTypes.lycanites.canShow()) {
            list.addAll(LycanitesHelperClient.getStacks());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
    }

    public String func_77653_i(ItemStack stack) {
        String name = HeadUtils.getName(stack);
        if (name != null) {
            boolean isPlayer;
            boolean isLycanites = stack.func_77960_j() == SkullTypes.lycanites.ordinal();
            boolean bl = isPlayer = stack.func_77960_j() == SkullTypes.player.ordinal();
            if (isLycanites || isPlayer) {
                return StatCollector.func_74837_a((String)"item.skull.player.name", (Object[])new Object[]{isLycanites ? LycanitesHelper.capitaliseString(name) : name});
            }
        }
        return super.func_77653_i(stack);
    }
}

