/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.utils;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumicenergistics.common.network.packet.client.Packet_C_Sync;
import thaumicenergistics.common.utils.EffectiveSide;

public final class ThEUtils {
    private static final double SQUARED_REACH = 64.0;

    @SideOnly(value=Side.CLIENT)
    private static final void playLocalSound(ResourceLocation sound) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)sound, (float)1.0f));
    }

    public static final boolean canPlayerInteractWith(@Nonnull EntityPlayer player, @Nonnull TileEntity tile) {
        TileEntity tileAtCoords = tile.func_145831_w().func_147438_o(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        if (tileAtCoords == null) {
            return false;
        }
        return player.func_70092_e((double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5) <= 64.0;
    }

    public static final boolean isItemValidWand(ItemStack stack, boolean allowStaves) {
        Item potentialWand;
        if (stack == null || (potentialWand = stack.func_77973_b()) == null) {
            return false;
        }
        if (!(potentialWand instanceof ItemWandCasting)) {
            return false;
        }
        if (!allowStaves && ((ItemWandCasting)potentialWand).isStaff(stack)) {
            return false;
        }
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        try {
            wand.getAspectsWithRoom(stack);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static final float pingPongFromTime(double speedReduction, float minValue, float maxValue) {
        if (minValue == maxValue) {
            return minValue;
        }
        if (speedReduction <= 0.0) {
            speedReduction = 1.4E-45f;
        }
        float time = (float)((double)System.currentTimeMillis() / speedReduction % 2000.0);
        time = Math.abs(time - 1000.0f);
        float timePercentage = time / 1000.0f;
        float rangePercentage = (maxValue - minValue) * timePercentage;
        return minValue + rangePercentage;
    }

    public static final void playClientSound(@Nullable EntityPlayer player, String soundLocation) {
        if (soundLocation == null || soundLocation == "") {
            return;
        }
        if (EffectiveSide.isClientSide()) {
            ResourceLocation sound = new ResourceLocation(soundLocation);
            ThEUtils.playLocalSound(sound);
        } else if (player != null) {
            Packet_C_Sync.sendPlaySound(player, soundLocation);
        }
    }
}

