/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import ftb.lib.BlockDimPos;
import ftb.lib.LMDimUtils;
import latmod.lib.LMUtils;
import latmod.lib.MathHelperLM;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;

public final class EntityPos
implements Cloneable {
    public final double x;
    public final double y;
    public final double z;
    public final int dim;

    public EntityPos(double px, double py, double pz, int d) {
        this.x = px;
        this.y = py;
        this.z = pz;
        this.dim = d;
    }

    public EntityPos(Entity e) {
        this(e.field_70165_t, e.field_70163_u, e.field_70161_v, e.field_71093_bK);
    }

    public int hashCode() {
        return LMUtils.hashCode(this.x, this.y, this.z, this.dim);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.x);
        sb.append(',');
        sb.append(this.y);
        sb.append(',');
        sb.append(this.z);
        sb.append(',');
        sb.append(LMDimUtils.getDimName(this.dim));
        sb.append(']');
        return sb.toString();
    }

    public boolean equalsPos(Entity e) {
        return this.x == e.field_70165_t && this.y == e.field_70163_u && this.z == e.field_70161_v && this.dim == e.field_71093_bK;
    }

    public boolean equalsPos(EntityPos p) {
        return p == this || p != null && this.toLinkedPos().equalsPos(p.toLinkedPos());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Entity) {
            return this.equalsPos((Entity)o);
        }
        return this.equalsPos((EntityPos)o);
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public EntityPos clone() {
        return new EntityPos(this.x, this.y, this.z, this.dim);
    }

    public BlockDimPos toLinkedPos() {
        return new BlockDimPos(MathHelperLM.floor(this.x), MathHelperLM.floor(this.y), MathHelperLM.floor(this.z), this.dim);
    }
}

