/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.td.subproxies;

import cofh.thermaldynamics.core.TickHandler;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.td.LPItemDuct;
import logisticspipes.proxy.td.subproxies.ITDPart;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TDPart
implements ITDPart {
    private final LogisticsTileGenericPipe pipe;
    private final LPItemDuct[] thermalDynamicsDucts;

    public TDPart(LogisticsTileGenericPipe pipe) {
        this.pipe = pipe;
        this.thermalDynamicsDucts = new LPItemDuct[6];
    }

    @Override
    public TileEntity getInternalDuctForSide(ForgeDirection opposite) {
        if (opposite.ordinal() < 6) {
            LPItemDuct duct = this.thermalDynamicsDucts[opposite.ordinal()];
            if (duct == null) {
                LPItemDuct lPItemDuct = new LPItemDuct(this.pipe, opposite);
                this.thermalDynamicsDucts[opposite.ordinal()] = lPItemDuct;
                duct = lPItemDuct;
                if (MainProxy.isServer(this.pipe.func_145831_w())) {
                    TickHandler.addMultiBlockToCalculate((IMultiBlock)duct);
                }
                duct.func_145834_a(this.pipe.func_145831_w());
                duct.field_145851_c = this.pipe.field_145851_c;
                duct.field_145848_d = this.pipe.field_145848_d;
                duct.field_145849_e = this.pipe.field_145849_e;
                duct.func_145829_t();
                LPPosition pos = new LPPosition(this.pipe);
                pos.moveForward(opposite);
                duct.onNeighborTileChange(pos.getX(), pos.getY(), pos.getZ());
            }
            return duct;
        }
        return null;
    }

    @Override
    public void setWorldObj_LP(World world) {
        for (int i = 0; i < 6; ++i) {
            if (this.thermalDynamicsDucts[i] == null) continue;
            this.thermalDynamicsDucts[i].func_145834_a(world);
            this.thermalDynamicsDucts[i].field_145851_c = this.pipe.field_145851_c;
            this.thermalDynamicsDucts[i].field_145848_d = this.pipe.field_145848_d;
            this.thermalDynamicsDucts[i].field_145849_e = this.pipe.field_145849_e;
        }
    }

    @Override
    public void invalidate() {
        for (int i = 0; i < 6; ++i) {
            if (this.thermalDynamicsDucts[i] == null) continue;
            this.thermalDynamicsDucts[i].func_145843_s();
        }
    }

    @Override
    public void onChunkUnload() {
        for (int i = 0; i < 6; ++i) {
            if (this.thermalDynamicsDucts[i] == null) continue;
            this.thermalDynamicsDucts[i].onChunkUnload();
        }
    }

    @Override
    public void scheduleNeighborChange() {
        for (int i = 0; i < 6; ++i) {
            if (this.thermalDynamicsDucts[i] == null) continue;
            this.thermalDynamicsDucts[i].onNeighborBlockChange();
        }
    }

    @Override
    public void connectionsChanged() {
        for (int i = 0; i < 6; ++i) {
            if (this.thermalDynamicsDucts[i] == null || this.thermalDynamicsDucts[i].myGrid == null) continue;
            this.thermalDynamicsDucts[i].myGrid.destroyAndRecreate();
        }
    }
}

