/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.fakes;

import com.rwtema.funkylocomotion.blocks.TileMovingClient;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;

@SideOnly(value=Side.CLIENT)
public class FakeWorldClient
extends WorldClient {
    private static final HashMap<World, FakeWorldClient> cache = new HashMap();
    public double offset = 0.0;
    public ForgeDirection dir = ForgeDirection.UNKNOWN;
    final World world;
    final WorldClient worldClient;

    private FakeWorldClient(World world) {
        super(new NetHandlerPlayClient(Minecraft.func_71410_x(), null, new NetworkManager(true)), new WorldSettings(world.func_72912_H()), world.field_73011_w.field_76574_g, world.field_73013_u, world.field_72984_F);
        this.world = world;
        this.worldClient = world instanceof WorldClient ? (WorldClient)world : null;
    }

    public static boolean isValid(World world) {
        return world != null && world.field_73011_w != null && DimensionManager.isDimensionRegistered((int)world.field_73011_w.field_76574_g);
    }

    public static FakeWorldClient getFakeWorldWrapper(World world) {
        FakeWorldClient fakeWorldClient = cache.get(world);
        if (fakeWorldClient == null) {
            fakeWorldClient = new FakeWorldClient(world);
            cache.put(world, fakeWorldClient);
        }
        return fakeWorldClient;
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new FakeWorldManager());
    }

    public boolean func_147445_c(int p_147445_1_, int p_147445_2_, int p_147445_3_, boolean p_147445_4_) {
        Block block = this.func_147439_a(p_147445_1_, p_147445_2_, p_147445_3_);
        return block.isNormalCube((IBlockAccess)this, p_147445_1_, p_147445_2_, p_147445_3_);
    }

    protected boolean func_72916_c(int p_72916_1_, int p_72916_2_) {
        return this.world.func_72899_e(p_72916_1_ << 4, 100, p_72916_2_ << 4);
    }

    public Chunk func_72964_e(int p_72964_1_, int p_72964_2_) {
        return this.world.func_72964_e(p_72964_1_, p_72964_2_);
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    protected int func_152379_p() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    public Entity func_73045_a(int p_73045_1_) {
        return this.world.func_73045_a(p_73045_1_);
    }

    public TileMovingClient getTile(int x, int y, int z) {
        TileEntity tile = this.world.func_147438_o(x, y, z);
        return tile != null && tile.getClass() == TileMovingClient.class ? (TileMovingClient)tile : null;
    }

    public Block func_147439_a(int x, int y, int z) {
        TileMovingClient tile = this.getTile(x, y, z);
        if (tile != null) {
            return tile.block;
        }
        return Blocks.field_150350_a;
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        TileMovingClient tile = this.getTile(x, y, z);
        return tile == null ? null : tile.tile;
    }

    public boolean func_147465_d(int p_147465_1_, int p_147465_2_, int p_147465_3_, Block p_147465_4_, int p_147465_5_, int p_147465_6_) {
        return false;
    }

    public boolean func_147463_c(EnumSkyBlock p_147463_1_, int p_147463_2_, int p_147463_3_, int p_147463_4_) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72802_i(int p_72802_1_, int p_72802_2_, int p_72802_3_, int p_72802_4_) {
        return this.world.func_72802_i(p_72802_1_, p_72802_2_, p_72802_3_, p_72802_4_);
    }

    public int func_72805_g(int x, int y, int z) {
        TileMovingClient tile = this.getTile(x, y, z);
        return tile == null ? 0 : tile.meta;
    }

    public int func_72879_k(int p_72879_1_, int p_72879_2_, int p_72879_3_, int p_72879_4_) {
        return this.world.func_72879_k(p_72879_1_, p_72879_2_, p_72879_3_, p_72879_4_);
    }

    public boolean func_147437_c(int x, int y, int z) {
        TileMovingClient tile = this.getTile(x, y, z);
        return tile == null || tile.block == Blocks.field_150350_a;
    }

    @SideOnly(value=Side.CLIENT)
    public BiomeGenBase func_72807_a(int p_72807_1_, int p_72807_2_) {
        return this.world.func_72807_a(p_72807_1_, p_72807_2_);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72800_K() {
        return this.world.func_72800_K();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_72806_N() {
        return this.world.func_72806_N();
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        TileMovingClient tile = this.getTile(x, y, z);
        return tile != null && tile.block.isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    public boolean func_72838_d(Entity p_72838_1_) {
        return false;
    }

    public void func_72869_a(String type, double x, double y, double z, double r, double g, double b) {
        this.world.func_72869_a(type, x + this.offset * (double)this.dir.offsetX, y + this.offset * (double)this.dir.offsetY, z + this.offset * (double)this.dir.offsetZ, r, g, b);
    }

    public void func_72835_b() {
    }

    public CrashReportCategory func_72914_a(CrashReport p_72914_1_) {
        CrashReportCategory crashReportCategory = this.world.func_72914_a(p_72914_1_);
        crashReportCategory.func_71507_a("Fake World", (Object)"This world is a fake wrapper used by Funky Locomotion");
        return crashReportCategory;
    }

    public void func_73029_E(int p_73029_1_, int p_73029_2_, int p_73029_3_) {
        if (this.worldClient != null) {
            this.worldClient.func_73029_E(p_73029_1_, p_73029_2_, p_73029_3_);
        }
    }

    public void func_92088_a(double p_92088_1_, double p_92088_3_, double p_92088_5_, double p_92088_7_, double p_92088_9_, double p_92088_11_, NBTTagCompound p_92088_13_) {
        if (this.worldClient != null) {
            this.worldClient.func_92088_a(p_92088_1_, p_92088_3_, p_92088_5_, p_92088_7_, p_92088_9_, p_92088_11_, p_92088_13_);
        }
    }

    public boolean func_147492_c(int p_147492_1_, int p_147492_2_, int p_147492_3_, Block p_147492_4_, int p_147492_5_) {
        return false;
    }

    public void func_72900_e(Entity p_72900_1_) {
    }

    public void func_73027_a(int p_73027_1_, Entity p_73027_2_) {
    }

    public Entity func_73028_b(int p_73028_1_) {
        return null;
    }

    public void func_72980_b(double p_72980_1_, double p_72980_3_, double p_72980_5_, String p_72980_7_, float p_72980_8_, float p_72980_9_, boolean p_72980_10_) {
        if (this.worldClient != null) {
            this.worldClient.func_72980_b(p_72980_1_, p_72980_3_, p_72980_5_, p_72980_7_, p_72980_8_, p_72980_9_, p_72980_10_);
        }
    }

    public void func_73022_a() {
    }

    public void func_73025_a(int p_73025_1_, int p_73025_2_, boolean p_73025_3_) {
    }

    protected void func_147456_g() {
    }

    public void func_72882_A() {
        this.world.func_72882_A();
    }

    @SideOnly(value=Side.CLIENT)
    public static class FakeWorldManager {
        @SubscribeEvent
        public void onDimensionUnload(WorldEvent.Unload event) {
            cache.remove(event.world);
            MinecraftServer server = MinecraftServer.func_71276_C();
            if (server != null && !server.func_71278_l()) {
                cache.clear();
            }
        }
    }
}

