/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.naming;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import stevesaddons.items.ItemLabeler;
import stevesaddons.items.ItemSFMDrive;
import stevesaddons.naming.NameData;
import stevesaddons.naming.NameRegistry;
import stevesaddons.network.MessageHandler;
import stevesaddons.network.message.SearchRegistryGenerateMessage;
import stevesaddons.registry.ItemRegistry;
import vswe.stevesfactory.blocks.TileEntityManager;

public class EventHandler {
    @SubscribeEvent
    public void playerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            NameRegistry.syncNameData((EntityPlayerMP)event.player);
            MessageHandler.INSTANCE.sendTo((IMessage)new SearchRegistryGenerateMessage(), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        NameRegistry.removeName(event.world, event.x, event.y, event.z);
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        WorldSavedData data = event.world.perWorldStorage.func_75742_a(NameData.class, "stevesaddons.namedata");
        if (data != null) {
            NameRegistry.setWorldData(event.world.field_73011_w.field_76574_g, (NameData)data);
        }
    }

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        NameData nameData = NameRegistry.getWorldData(event.world.field_73011_w.field_76574_g, false);
        if (nameData != null) {
            event.world.perWorldStorage.func_75745_a("stevesaddons.namedata", (WorldSavedData)nameData);
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        NameData nameData = NameRegistry.getWorldData(event.world.field_73011_w.field_76574_g, false);
        if (nameData != null) {
            event.world.perWorldStorage.func_75745_a("stevesaddons.namedata", (WorldSavedData)nameData);
        }
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        ItemStack stack = event.entityPlayer.func_71045_bC();
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && stack != null) {
            TileEntity te;
            World world = event.world;
            int x = event.x;
            int y = event.y;
            int z = event.z;
            EntityPlayer player = event.entityPlayer;
            if (stack.func_77973_b() == ItemRegistry.labeler) {
                if (ItemLabeler.isValidTile(world, x, y, z)) {
                    String label = ItemLabeler.getLabel(stack);
                    if (label.isEmpty()) {
                        if (NameRegistry.removeName(world, x, y, z)) {
                            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"stevesaddons.chat.cleared")));
                        }
                    } else {
                        NameRegistry.saveName(world, x, y, z, label);
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"stevesaddons.chat.saved", (Object[])new Object[]{label})));
                    }
                    event.setCanceled(true);
                }
            } else if (stack.func_77973_b() == ItemRegistry.duplicator && player.func_70093_af() && (te = world.func_147438_o(x, y, z)) instanceof TileEntityManager) {
                world.func_147475_p(x, y, z);
                TileEntityManager manager = new TileEntityManager();
                if (stack.func_77942_o() && ItemSFMDrive.validateNBT(stack)) {
                    manager.func_145839_a(stack.func_77978_p());
                    stack.func_77982_d(null);
                }
                world.func_147455_a(x, y, z, (TileEntity)manager);
                event.setCanceled(true);
            }
        }
    }
}

