/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.interfaces;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.animation.AnimationController;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.interfaces.IInterfaceRenderer;
import vswe.stevesfactory.network.DataWriter;
import vswe.stevesfactory.network.PacketHandler;

@SideOnly(value=Side.CLIENT)
public class GuiRFManager
extends GuiManager {
    private static final ResourceLocation BACKGROUND_1 = GuiRFManager.registerTexture((String)"Background1");
    private static final ResourceLocation BACKGROUND_2 = GuiRFManager.registerTexture((String)"Background2");
    private static final ResourceLocation COMPONENTS = new ResourceLocation("stevesaddons", "textures/gui/FlowComponents.png");
    public static int Z_LEVEL_COMPONENT_OPEN_DIFFERENCE = 100;
    public static int Z_LEVEL_COMPONENT_CLOSED_DIFFERENCE = 1;
    public static int Z_LEVEL_COMPONENT_START = 750;
    public static int Z_LEVEL_OPEN_MAXIMUM = 5;
    private long lastTicks;
    private AnimationController controller;
    private boolean doubleShiftFlag;
    private boolean useGreenScreen;
    private boolean useBlueScreen;
    private boolean usePinkScreen;
    private boolean useButtons = true;
    private boolean useInfo = true;
    private boolean useMouseOver = true;
    private List<SecretCode> codes = new ArrayList<SecretCode>();
    private TileEntityManager manager;

    public GuiRFManager(TileEntityManager manager, InventoryPlayer player) {
        super(manager, player);
        this.codes.add(new SecretCode("animate"){

            @Override
            protected void trigger() {
                GuiRFManager.this.controller = new AnimationController(GuiRFManager.this.manager, 2);
            }
        });
        this.codes.add(new SecretCode("animslow"){

            @Override
            protected void trigger() {
                GuiRFManager.this.controller = new AnimationController(GuiRFManager.this.manager, 1);
            }
        });
        this.codes.add(new SecretCode("animfast"){

            @Override
            protected void trigger() {
                GuiRFManager.this.controller = new AnimationController(GuiRFManager.this.manager, 5);
            }
        });
        this.codes.add(new SecretCode("animrapid"){

            @Override
            protected void trigger() {
                GuiRFManager.this.controller = new AnimationController(GuiRFManager.this.manager, 20);
            }
        });
        this.codes.add(new SecretCode("animinstant"){

            @Override
            protected void trigger() {
                GuiRFManager.this.controller = new AnimationController(GuiRFManager.this.manager, 100);
            }
        });
        this.codes.add(new SecretCode("green"){

            @Override
            protected void trigger() {
                GuiRFManager.this.useGreenScreen = !GuiRFManager.this.useGreenScreen;
                GuiRFManager.this.useBlueScreen = false;
                GuiRFManager.this.usePinkScreen = false;
            }
        });
        this.codes.add(new SecretCode("blue"){

            @Override
            protected void trigger() {
                GuiRFManager.this.useBlueScreen = !GuiRFManager.this.useBlueScreen;
                GuiRFManager.this.useGreenScreen = false;
                GuiRFManager.this.usePinkScreen = false;
            }
        });
        this.codes.add(new SecretCode("pink"){

            @Override
            protected void trigger() {
                GuiRFManager.this.usePinkScreen = !GuiRFManager.this.usePinkScreen;
                GuiRFManager.this.useGreenScreen = false;
                GuiRFManager.this.useBlueScreen = false;
            }
        });
        this.codes.add(new SecretCode("buttons"){

            @Override
            protected void trigger() {
                GuiRFManager.this.useButtons = !GuiRFManager.this.useButtons;
            }
        });
        this.codes.add(new SecretCode("info"){

            @Override
            protected void trigger() {
                GuiRFManager.this.useInfo = !GuiRFManager.this.useInfo;
            }
        });
        this.codes.add(new SecretCode("mouse"){

            @Override
            protected void trigger() {
                GuiRFManager.this.useMouseOver = !GuiRFManager.this.useMouseOver;
            }
        });
        this.xSize = 512;
        this.ySize = 256;
        this.manager = manager;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public ResourceLocation getComponentResource() {
        return COMPONENTS;
    }

    public void func_146270_b(int val) {
        if (this.usePinkScreen) {
            GuiRFManager.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1310580);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (this.useBlueScreen) {
            GuiRFManager.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-16774511);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else if (this.useGreenScreen) {
            GuiRFManager.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-16711936);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            super.func_146270_b(val);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int x, int y) {
        if (!(this.useGreenScreen || this.useBlueScreen || this.usePinkScreen)) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiRFManager.bindTexture((ResourceLocation)BACKGROUND_1);
            this.drawTexture(0, 0, 0, 0, 256, 256);
            GuiRFManager.bindTexture((ResourceLocation)BACKGROUND_2);
            this.drawTexture(256, 0, 0, 0, 256, 256);
        }
        x -= this.guiLeft;
        y -= this.guiTop;
        GuiRFManager.bindTexture((ResourceLocation)COMPONENTS);
        if (this.hasSpecialRenderer()) {
            this.getSpecialRenderer().draw((GuiManager)this, x, y);
            this.getSpecialRenderer().drawMouseOver((GuiManager)this, x, y);
        } else {
            if (this.useButtons) {
                for (int ticks = 0; ticks < this.manager.buttons.size(); ++ticks) {
                    TileEntityManager.Button button = (TileEntityManager.Button)this.manager.buttons.get(ticks);
                    if (!button.isVisible()) continue;
                    int elapsedSeconds = CollisionHelper.inBounds((int)button.getX(), (int)button.getY(), (int)14, (int)14, (int)x, (int)y) ? 1 : 0;
                    int column = ticks / 20;
                    this.drawTexture(button.getX(), button.getY(), 242, elapsedSeconds * 14, 14, 14);
                    this.drawTexture(button.getX() + 1, button.getY() + 1, 230 - column * 12, ticks % 20 * 12, 12, 12);
                }
            }
            long var11 = Minecraft.func_71386_F();
            float var12 = (float)(var11 - this.lastTicks) / 1000.0f;
            if (this.controller != null) {
                this.controller.update(var12);
            }
            for (FlowComponent openCount : this.manager.getFlowItems()) {
                openCount.update(var12);
            }
            this.lastTicks = var11;
            int var13 = Z_LEVEL_COMPONENT_START;
            int var14 = 0;
            for (int i$ = 0; i$ < this.manager.getZLevelRenderingList().size(); ++i$) {
                FlowComponent itemBase = (FlowComponent)this.manager.getZLevelRenderingList().get(i$);
                if (!itemBase.isVisible()) continue;
                if (itemBase.isOpen() && var14 == Z_LEVEL_OPEN_MAXIMUM) {
                    itemBase.close();
                }
                if (itemBase.isOpen()) {
                    var13 -= Z_LEVEL_COMPONENT_OPEN_DIFFERENCE;
                    ++var14;
                } else {
                    var13 -= Z_LEVEL_COMPONENT_CLOSED_DIFFERENCE;
                }
                itemBase.draw((GuiManager)this, x, y, var13);
                if (!itemBase.isBeingMoved() && !CollisionHelper.inBounds((int)itemBase.getX(), (int)itemBase.getY(), (int)itemBase.getComponentWidth(), (int)itemBase.getComponentHeight(), (int)x, (int)y)) continue;
                CollisionHelper.disableInBoundsCheck = true;
            }
            CollisionHelper.disableInBoundsCheck = false;
            if (this.useInfo) {
                this.drawString(this.getInfo(), 5, this.ySize - 13, 1.0f, 0x606060);
            }
            if (this.useMouseOver) {
                if (this.useButtons) {
                    for (TileEntityManager.Button var16 : this.manager.buttons) {
                        if (!var16.isVisible() || !CollisionHelper.inBounds((int)var16.getX(), (int)var16.getY(), (int)14, (int)14, (int)x, (int)y)) continue;
                        this.drawMouseOver(var16.getMouseOver(), x, y);
                    }
                }
                for (FlowComponent itemBase : this.manager.getZLevelRenderingList()) {
                    if (!itemBase.isVisible()) continue;
                    itemBase.drawMouseOver((GuiManager)this, x, y);
                    if (!itemBase.isBeingMoved() && !CollisionHelper.inBounds((int)itemBase.getX(), (int)itemBase.getY(), (int)itemBase.getComponentWidth(), (int)itemBase.getComponentHeight(), (int)x, (int)y)) continue;
                    CollisionHelper.disableInBoundsCheck = true;
                }
            }
            CollisionHelper.disableInBoundsCheck = false;
            if (!Keyboard.isKeyDown((int)54) && this.doubleShiftFlag) {
                this.doubleShiftFlag = false;
            }
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int scroll = Mouse.getEventDWheel();
        if (scroll != 0) {
            if (this.hasSpecialRenderer()) {
                this.getSpecialRenderer().onScroll(scroll);
                return;
            }
            for (FlowComponent component : this.manager.getZLevelRenderingList()) {
                if (!component.isVisible()) continue;
                component.doScroll(scroll);
                return;
            }
        }
    }

    private String getInfo() {
        String ret = Localization.COMMANDS.toString() + ": " + this.manager.getFlowItems().size() + "  ";
        String path = "";
        FlowComponent component = this.manager.getSelectedComponent();
        if (component != null) {
            ret = ret + "|";
        }
        while (component != null) {
            String nextPath = "> " + component.getName() + " " + path;
            if (this.getStringWidth(ret + nextPath) > this.xSize - 15) {
                path = "... " + path;
                break;
            }
            path = nextPath;
            component = component.getParent();
        }
        ret = ret + path;
        return ret;
    }

    protected void func_73869_a(char c, int k) {
        if (this.hasSpecialRenderer()) {
            this.getSpecialRenderer().onKeyTyped((GuiManager)this, c, k);
        } else {
            if (k == 54 && !this.doubleShiftFlag) {
                DataWriter recognized = PacketHandler.getWriterForServerActionPacket();
                PacketHandler.sendDataToServer((DataWriter)recognized);
                this.doubleShiftFlag = true;
            }
            for (Object i$ : this.manager.getZLevelRenderingList()) {
                if (!i$.isVisible() || !i$.onKeyStroke((GuiManager)this, c, k) || k == 1) continue;
                return;
            }
            boolean recognized2 = false;
            for (SecretCode code : this.codes) {
                if (!code.keyTyped(c)) continue;
                recognized2 = true;
            }
            if (recognized2) {
                return;
            }
        }
        super.func_73869_a(c, k);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        for (FlowComponent flowComponent : this.manager.getFlowItems()) {
            flowComponent.onGuiClosed();
        }
        super.func_146281_b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawItemStack(ItemStack itemstack, int x, int y) {
        GL11.glPushMatrix();
        RenderHelper.func_74520_c();
        GL11.glDisable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2903);
        GL11.glEnable((int)2896);
        GuiRFManager.field_146296_j.field_77023_b = 1.0f;
        try {
            GL11.glEnable((int)2929);
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), itemstack, x + this.guiLeft, y + this.guiTop);
            field_146296_j.func_94148_a(this.field_146289_q, this.field_146297_k.func_110434_K(), itemstack, x + this.guiLeft, y + this.guiTop, "");
        }
        catch (Exception var9) {
            if (itemstack != null && itemstack.func_77973_b() != null && itemstack.func_77960_j() != 0) {
                ItemStack newStack = itemstack.func_77946_l();
                newStack.func_77964_b(0);
                this.drawItemStack(newStack, x, y);
            }
        }
        finally {
            GuiRFManager.field_146296_j.field_77023_b = 0.0f;
            GuiRFManager.bindTexture((ResourceLocation)this.getComponentResource());
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3008);
            GL11.glPopMatrix();
        }
    }

    public TileEntityManager getManager() {
        return this.manager;
    }

    private boolean hasSpecialRenderer() {
        return this.getSpecialRenderer() != null;
    }

    private IInterfaceRenderer getSpecialRenderer() {
        return this.manager.specialRenderer;
    }

    private abstract class SecretCode {
        private final String code;
        private int triggerNumber;

        private SecretCode(String code) {
            this.code = code;
        }

        public boolean keyTyped(char c) {
            if (Character.isAlphabetic(c)) {
                if (this.code.charAt(this.triggerNumber) == c) {
                    if (this.triggerNumber + 1 > this.code.length() - 1) {
                        this.triggerNumber = 0;
                        this.trigger();
                    } else {
                        ++this.triggerNumber;
                    }
                    return true;
                }
                if (this.triggerNumber != 0) {
                    this.triggerNumber = 0;
                    this.keyTyped(c);
                }
            }
            return false;
        }

        protected abstract void trigger();
    }
}

