/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.peripheralproxy;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.Log;
import openmods.api.INeighbourAwareTile;
import openmods.api.INeighbourTeAwareTile;
import openmods.reflection.FieldAccess;
import openmods.reflection.MethodAccess;
import openmods.reflection.ReflectionHelper;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.Coord;
import openperipheral.addons.peripheralproxy.WrappedPeripheral;
import openperipheral.api.architecture.cc.ICustomPeripheralProvider;

public class TileEntityPeripheralProxy
extends OpenTileEntity
implements ICustomPeripheralProvider,
INeighbourAwareTile,
INeighbourTeAwareTile {
    private static final Access access = new Access();
    private Block attachedBlock;

    public static void initAccess() {
        Preconditions.checkNotNull((Object)access);
    }

    public IPeripheral createPeripheral(int side) {
        ForgeDirection rotation = this.getOrientation().up();
        if (rotation.getOpposite().ordinal() != side) {
            return null;
        }
        int targetX = this.field_145851_c + rotation.offsetX;
        int targetY = this.field_145848_d + rotation.offsetY;
        int targetZ = this.field_145849_e + rotation.offsetZ;
        IPeripheral peripheral = (IPeripheral)TileEntityPeripheralProxy.access.getPeripheralAt.call(null, (Object)this.field_145850_b, (Object)targetX, (Object)targetY, (Object)targetZ, (Object)0);
        if (peripheral != null) {
            this.attachedBlock = this.field_145850_b.func_147439_a(targetX, targetY, targetZ);
            return new WrappedPeripheral(peripheral);
        }
        this.attachedBlock = null;
        return null;
    }

    private void handlePeripheralUpdate(ForgeDirection targetDir) {
        boolean isConnected = this.isProxyActive(targetDir);
        ForgeDirection modemDir = targetDir.getOpposite();
        this.updateModem(modemDir, isConnected);
    }

    public void onNeighbourChanged(Block block) {
        if (!(this.field_145850_b.field_72995_K || block != null && block != this.attachedBlock)) {
            ForgeDirection targetDir = this.getOrientation().up();
            this.handlePeripheralUpdate(targetDir);
        }
    }

    public void onNeighbourTeChanged(int x, int y, int z) {
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection targetDir = this.getOrientation().up();
            if (this.getPosition().offset(targetDir).equals((Object)new Coord(x, y, z))) {
                this.handlePeripheralUpdate(targetDir);
            }
        }
    }

    private boolean isProxyActive(ForgeDirection targetDir) {
        int targetX = this.field_145851_c + targetDir.offsetX;
        int targetY = this.field_145848_d + targetDir.offsetY;
        int targetZ = this.field_145849_e + targetDir.offsetZ;
        return this.field_145850_b.func_147438_o(targetX, targetY, targetZ) != null;
    }

    private void updateModem(ForgeDirection modemDir, boolean reactivate) {
        int attachedX = this.field_145851_c + modemDir.offsetX;
        int attachedY = this.field_145848_d + modemDir.offsetY;
        int attachedZ = this.field_145849_e + modemDir.offsetZ;
        TileEntity attachedModem = this.field_145850_b.func_147438_o(attachedX, attachedY, attachedZ);
        try {
            boolean isActive;
            if (attachedModem != null && TileEntityPeripheralProxy.access.cableClass.isAssignableFrom(attachedModem.getClass()) && (isActive = ((Boolean)TileEntityPeripheralProxy.access.isModemConnected.get((Object)attachedModem)).booleanValue())) {
                TileEntityPeripheralProxy.access.togglePeripheral.call((Object)attachedModem);
                if (reactivate) {
                    TileEntityPeripheralProxy.access.togglePeripheral.call((Object)attachedModem);
                }
            }
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Failed to update modem %s", (Object[])new Object[]{attachedModem});
        }
        this.field_145850_b.func_147460_e(attachedX, attachedY, attachedZ, this.func_145838_q());
    }

    private static class Access {
        public final Class<?> ccClass = ReflectionHelper.getClass((String)"dan200.computercraft.ComputerCraft");
        public final Class<?> cableClass = ReflectionHelper.getClass((String)"dan200.computercraft.shared.peripheral.modem.TileCable");
        public final FieldAccess<Boolean> isModemConnected = FieldAccess.create(this.cableClass, (String[])new String[]{"m_peripheralAccessAllowed"});
        public final MethodAccess.Function0<Void> togglePeripheral = MethodAccess.create(Void.TYPE, this.cableClass, (String[])new String[]{"togglePeripheralAccess"});
        public final MethodAccess.Function5<IPeripheral, World, Integer, Integer, Integer, Integer> getPeripheralAt = MethodAccess.create(IPeripheral.class, this.ccClass, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, (String[])new String[]{"getPeripheralAt"});

        private Access() {
        }
    }
}

