/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import openmods.network.event.NetworkEvent;
import openperipheral.addons.Config;
import openperipheral.addons.glasses.GlassesEvent;
import openperipheral.addons.glasses.client.TerminalManagerClient;
import openperipheral.addons.utils.GuiUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiCapture
extends GuiScreen {
    private int backgroundColor = 704708352;
    private final long guid;
    private int mouseButtonsDown;
    private float lastDragX;
    private float lastDragY;
    private int dragInterval;
    private float dragThresholdSquared = Config.defaultDragThreshold * Config.defaultDragThreshold;
    private int dragPeriod = Config.defaultDragPeriod;
    private final Map<GuiUtils.GuiElements, Boolean> originalState;
    private final Map<GuiUtils.GuiElements, Boolean> updatedState;

    public GuiCapture(long guid) {
        this.guid = guid;
        this.originalState = GuiUtils.storeGuiElementsState();
        this.updatedState = Maps.newEnumMap(GuiUtils.GuiElements.class);
    }

    public void func_146274_d() {
        float dy;
        float dx;
        super.func_146274_d();
        int button = Mouse.getEventButton();
        int wheel = Mouse.getEventDWheel();
        int mx = Mouse.getEventX();
        int my = Mouse.getEventY();
        float scaleX = (float)this.field_146294_l / (float)this.field_146297_k.field_71443_c;
        float scaleY = (float)this.field_146295_m / (float)this.field_146297_k.field_71440_d;
        float x = (float)mx * scaleX;
        float y = (float)this.field_146295_m - (float)my * scaleY;
        if (button != -1 || wheel != 0) {
            ScaledResolution resolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
            TerminalManagerClient.DrawableHitInfo hit = TerminalManagerClient.instance.findDrawableHit(this.guid, resolution, x, y);
            if (button != -1) {
                boolean state = Mouse.getEventButtonState();
                this.createMouseButtonEvent(button, state, hit).sendToServer();
                boolean draggingStarted = this.updateButtonCounter(state);
                if (draggingStarted) {
                    this.resetDraggingLimiter(x, y);
                }
            }
            if (wheel != 0) {
                this.createMouseWheelEvent(wheel, hit).sendToServer();
            }
        }
        if (this.canSendDragEvent(dx = x - this.lastDragX, dy = y - this.lastDragY)) {
            this.createDragEvent(dx, dy).sendToServer();
            this.resetDraggingLimiter(x, y);
        }
    }

    private boolean updateButtonCounter(boolean isPressed) {
        if (isPressed) {
            return ++this.mouseButtonsDown == 1;
        }
        this.mouseButtonsDown = Math.max(this.mouseButtonsDown - 1, 0);
        return false;
    }

    private void resetDraggingLimiter(float x, float y) {
        this.lastDragX = x;
        this.lastDragY = y;
        this.dragInterval = this.dragPeriod;
    }

    private boolean canSendDragEvent(float dx, float dy) {
        if (this.mouseButtonsDown <= 0) {
            return false;
        }
        if (this.dragInterval >= 0) {
            return false;
        }
        float d = dx * dx + dy * dy;
        return d >= this.dragThresholdSquared;
    }

    public void func_73876_c() {
        super.func_73876_c();
        --this.dragInterval;
    }

    private NetworkEvent createDragEvent(float dx, float dy) {
        return new GlassesEvent.GlassesMouseDragEvent(this.guid, dx, dy);
    }

    private NetworkEvent createMouseButtonEvent(int button, boolean state, TerminalManagerClient.DrawableHitInfo hit) {
        return hit != null ? new GlassesEvent.GlassesComponentMouseButtonEvent(this.guid, hit.id, hit.surfaceType, hit.dx, hit.dy, button, state) : new GlassesEvent.GlassesMouseButtonEvent(this.guid, button, state);
    }

    private NetworkEvent createMouseWheelEvent(int wheel, TerminalManagerClient.DrawableHitInfo hit) {
        return hit != null ? new GlassesEvent.GlassesComponentMouseWheelEvent(this.guid, hit.id, hit.surfaceType, hit.dx, hit.dy, wheel) : new GlassesEvent.GlassesMouseWheelEvent(this.guid, wheel);
    }

    public void func_146282_l() {
        int key = Keyboard.getEventKey();
        if (key == 1) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else {
            boolean state = Keyboard.getEventKeyState();
            if (state) {
                char ch = GuiCapture.sanitizeKeyChar(Keyboard.getEventCharacter());
                boolean isRepeat = Keyboard.isRepeatEvent();
                new GlassesEvent.GlassesKeyDownEvent(this.guid, ch, key, isRepeat).sendToServer();
            } else {
                new GlassesEvent.GlassesKeyUpEvent(this.guid, key).sendToServer();
            }
        }
        super.func_146282_l();
    }

    private static char sanitizeKeyChar(char ch) {
        switch (Character.getType(ch)) {
            case 0: 
            case 18: {
                return '\u0000';
            }
        }
        return ch;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTickTime) {
        GuiCapture.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)this.backgroundColor);
    }

    public void func_73866_w_() {
        new GlassesEvent.GlassesSignalCaptureEvent(this.guid, true).sendToServer();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_146281_b() {
        new GlassesEvent.GlassesSignalCaptureEvent(this.guid, false).sendToServer();
        Keyboard.enableRepeatEvents((boolean)false);
        GuiUtils.loadGuiElementsState(this.originalState);
    }

    public boolean func_73868_f() {
        return false;
    }

    public long getGuid() {
        return this.guid;
    }

    public void setBackground(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setKeyRepeat(boolean repeat) {
        Keyboard.enableRepeatEvents((boolean)repeat);
    }

    public void setDragParameters(int threshold, int period) {
        this.dragPeriod = period;
        this.dragThresholdSquared = threshold * threshold;
    }

    public void updateGuiElementsState(Map<GuiUtils.GuiElements, Boolean> visibility) {
        this.updatedState.putAll(visibility);
    }

    public void forceGuiElementsState() {
        GuiUtils.loadGuiElementsState(this.updatedState);
    }
}

