/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.tile;

import cofh.api.energy.IEnergyContainerItem;
import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.endertech.fx.EntityChargePadFX;
import io.endertech.gui.client.GuiChargePad;
import io.endertech.gui.container.ContainerChargePad;
import io.endertech.network.PacketETBase;
import io.endertech.tile.TilePad;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.StringHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class TileChargePad
extends TilePad {
    public static final int[] RECEIVE = new int[]{0, 2000, 20000};
    public static final int[] SEND = new int[]{10000000, 2000, 20000};
    public static final int[] CAPACITY = new int[]{-1, 2000000, 10000000};
    public int sentPower = 0;

    public TileChargePad() {
        this.tileName = "Charge Pad";
    }

    public static void init() {
        GameRegistry.registerTileEntity(TileChargePad.class, (String)"tile.chargePad");
    }

    @Override
    public int getMaxEnergyStored(int meta) {
        return CAPACITY[meta];
    }

    @Override
    public int getMaxReceiveRate(int meta) {
        return RECEIVE[meta];
    }

    @Override
    public int getMaxSendRate(int meta) {
        return SEND[meta];
    }

    public String toString() {
        return "Charge Pad: position " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e;
    }

    public Set<ItemStack> chargeableItemsInInventory(ItemStack[] itemStacks) {
        HashSet<ItemStack> itemsToCharge = new HashSet<ItemStack>();
        for (ItemStack itemStack : itemStacks) {
            IEnergyContainerItem chargeableItem;
            Item item;
            if (itemStack == null || !((item = itemStack.func_77973_b()) instanceof IEnergyContainerItem) || (chargeableItem = (IEnergyContainerItem)item).receiveEnergy(itemStack, 1, true) != 1) continue;
            itemsToCharge.add(itemStack);
        }
        return itemsToCharge;
    }

    public List<Entity> getChargeableEntitiesInAABB(AxisAlignedBB aabb) {
        List chargeableEntitiesInRange = this.field_145850_b.func_72872_a(EntityPlayer.class, aabb);
        List chargeableItemsInRange = this.field_145850_b.func_72872_a(EntityItem.class, aabb);
        for (EntityItem entityItem : chargeableItemsInRange) {
            Item item;
            ItemStack itemStack = entityItem.func_92059_d();
            if (itemStack == null || (item = itemStack.func_77973_b()) == null || !(item instanceof IEnergyContainerItem)) continue;
            chargeableEntitiesInRange.add(entityItem);
        }
        return chargeableEntitiesInRange;
    }

    public List<ItemStack> getItemsToChargeFromEntity(Entity entity) {
        LinkedList<ItemStack> itemsToCharge = new LinkedList<ItemStack>();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            itemsToCharge.addAll(this.chargeableItemsInInventory(player.field_71071_by.field_70462_a));
            itemsToCharge.addAll(this.chargeableItemsInInventory(player.field_71071_by.field_70460_b));
        } else if (entity instanceof EntityItem) {
            EntityItem entityItem = (EntityItem)entity;
            ItemStack item = entityItem.func_92059_d();
            if (item.field_77994_a == 1) {
                itemsToCharge.add(item);
            }
        }
        return itemsToCharge;
    }

    public int chargeItemsGivenEntity(Entity entity, int maxCharge, int meta) {
        List<ItemStack> itemsToCharge = this.getItemsToChargeFromEntity(entity);
        double efficiency = this.calculateEfficiencyForEntity(entity);
        int totalSent = 0;
        int itemCount = itemsToCharge.size();
        if (itemCount > 0) {
            int chargePerItem = (int)Math.floor(maxCharge / itemCount);
            if (chargePerItem == 0 && maxCharge > 0) {
                chargePerItem = 1;
            }
            for (ItemStack itemStack : itemsToCharge) {
                int sent;
                IEnergyContainerItem chargeableItem = (IEnergyContainerItem)itemStack.func_77973_b();
                int couldReceive = chargeableItem.receiveEnergy(itemStack, chargePerItem, true);
                int toSend = this.extractEnergy(couldReceive, meta, false);
                if (this.isCreative) {
                    toSend = couldReceive;
                }
                if ((sent = chargeableItem.receiveEnergy(itemStack, (int)((double)toSend * efficiency), false)) > 0 && entity instanceof EntityItem) {
                    EntityItem entityItem = (EntityItem)entity;
                    if (entityItem.lifespan < Integer.MAX_VALUE) {
                        entityItem.lifespan = Integer.MAX_VALUE;
                    }
                }
                totalSent += sent;
            }
            if (totalSent >= maxCharge) {
                return maxCharge;
            }
        }
        return totalSent;
    }

    public void func_145845_h() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean bl = this.isCreative = meta == 0;
        if (ServerHelper.isServerWorld(this.field_145850_b)) {
            boolean oldActive = this.isActive;
            this.isActive = this.sentPower > 0;
            this.sentPower = 0;
            int totalChargeSendable = this.extractEnergy(this.getMaxSendRate(meta), meta, true);
            if (this.isCreative) {
                totalChargeSendable = SEND[0];
            }
            if (totalChargeSendable > 0) {
                AxisAlignedBB front = this.getAABBInFront(2);
                List<Entity> ownersInRange = this.getChargeableEntitiesInAABB(front);
                int totalChargeForEntity = (int)((double)totalChargeSendable / (double)ownersInRange.size());
                if (ownersInRange.size() > 0) {
                    for (Entity entity : ownersInRange) {
                        int powerSentToEntity = this.chargeItemsGivenEntity(entity, totalChargeForEntity, meta);
                        this.sentPower += powerSentToEntity;
                    }
                }
            }
            this.chargeFromGUISlot();
            boolean shouldSendUpdate = false;
            boolean bl2 = shouldSendUpdate = shouldSendUpdate || this.isActive != oldActive;
            if (this.ticksSinceLastUpdate == 20) {
                this.ticksSinceLastUpdate = 0;
                shouldSendUpdate = true;
            }
            if (shouldSendUpdate) {
                this.sendDescriptionPacket();
            }
            this.ticksSinceLastUpdate = (short)(this.ticksSinceLastUpdate + 1);
            if (this.ticksSinceLastUpdate > 20) {
                this.ticksSinceLastUpdate = (short)20;
            }
        }
        if (this.sentPower > 0 && ServerHelper.isClientWorld(this.field_145850_b)) {
            this.spawnParticles(meta);
        }
    }

    @Override
    public PacketETBase getPacket() {
        PacketETBase packet = super.getPacket();
        packet.addInt(this.sentPower);
        return packet;
    }

    @Override
    public void handleTilePacket(PacketETBase tilePacket, boolean isServer) {
        super.handleTilePacket(tilePacket, isServer);
        int sentPower = tilePacket.getInt();
        if (!isServer) {
            this.sentPower = sentPower;
        }
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip) {
        if (this.isActive) {
            currenttip.add(EnumChatFormatting.GREEN + LocalisationHelper.localiseString("info.active", new Object[0]) + EnumChatFormatting.RESET);
        } else {
            currenttip.add(EnumChatFormatting.RED + LocalisationHelper.localiseString("info.inactive", new Object[0]) + EnumChatFormatting.RESET);
        }
        int blockMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.isCreative) {
            currenttip.add(LocalisationHelper.localiseString("info.charge", "Infinite"));
        } else {
            currenttip.add(LocalisationHelper.localiseString("info.charge", StringHelper.getEnergyString(this.storedEnergy) + " / " + StringHelper.getEnergyString(this.getMaxEnergyStored(blockMeta)) + " RF"));
        }
        currenttip.add(LocalisationHelper.localiseString("info.sent", StringHelper.getEnergyString(this.sentPower) + " RF/t"));
        return currenttip;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(int meta) {
        EffectRenderer er = FMLClientHandler.instance().getClient().field_71452_i;
        ForgeDirection orientation = this.getOrientation();
        Random rand = this.field_145850_b.field_73012_v;
        for (int particle = this.getParticleCount(meta); particle > 0; --particle) {
            double xSign = rand.nextBoolean() ? -1 : 1;
            double ySign = rand.nextBoolean() ? -1 : 1;
            double zSign = rand.nextBoolean() ? -1 : 1;
            double xAddition = xSign * (rand.nextDouble() * 0.3) + 0.05 * xSign;
            double yAddition = ySign * (rand.nextDouble() * 0.3) + 0.05 * ySign;
            double zAddition = zSign * (rand.nextDouble() * 0.3) + 0.05 * zSign;
            double x = (double)((float)this.field_145851_c + 0.5f * (float)orientation.offsetX) + 0.5 + xAddition;
            double y = (double)((float)this.field_145848_d + 0.5f * (float)orientation.offsetY) + 0.5 + yAddition;
            double z = (double)((float)this.field_145849_e + 0.5f * (float)orientation.offsetZ) + 0.5 + zAddition;
            er.func_78873_a((EntityFX)new EntityChargePadFX(this.field_145850_b, x, y, z, this.getParticleMaxAge(), this.getParticleVelocity(), this.getParticleColour(rand), this.getParticleSizeModifier(meta)));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getParticleMaxAge() {
        return 16;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double[] getParticleVelocity() {
        ForgeDirection orientation = this.getOrientation();
        return new double[]{(double)orientation.offsetX * 0.15, (double)orientation.offsetY * 0.15, (double)orientation.offsetZ * 0.15};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float[] getParticleColour(Random rand) {
        if (this.isItemInChargeSlotTuberous()) {
            return this.getRainbowParticleColour(rand);
        }
        float r = 1.0f;
        float g = 0.0f + rand.nextFloat() * 0.25f;
        float b = 0.0f + rand.nextFloat() * 0.25f;
        return new float[]{r, g, b};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getParticleCount(int meta) {
        if (meta == 0) {
            return 5;
        }
        if (meta == 2) {
            return 2;
        }
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getParticleSizeModifier(int meta) {
        if (meta == 0) {
            return 2.0f;
        }
        if (meta == 2) {
            return 1.75f;
        }
        return 1.5f;
    }

    @Override
    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiChargePad(inventory, this);
    }

    @Override
    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerChargePad(inventory, this);
    }
}

