/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.net.message.multiblock;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorAccessPort;
import erogenousbeef.bigreactors.net.message.base.ReactorMessageServer;
import erogenousbeef.core.common.CoordTriplet;
import io.netty.buffer.ByteBuf;

public class ReactorCommandEjectToPortMessage
extends ReactorMessageServer {
    protected boolean ejectFuel;
    protected boolean dumpExcess;
    int portX;
    int portY;
    int portZ;

    public ReactorCommandEjectToPortMessage() {
        this.dumpExcess = false;
        this.ejectFuel = false;
        this.portZ = Integer.MAX_VALUE;
        this.portY = Integer.MAX_VALUE;
        this.portX = Integer.MAX_VALUE;
    }

    public ReactorCommandEjectToPortMessage(TileEntityReactorAccessPort destination, boolean ejectFuel, boolean dumpExcess) {
        super(destination.getReactorController());
        this.portX = destination.field_145851_c;
        this.portY = destination.field_145848_d;
        this.portZ = destination.field_145849_e;
        this.ejectFuel = ejectFuel;
        this.dumpExcess = dumpExcess;
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.ejectFuel = buf.readBoolean();
        this.dumpExcess = buf.readBoolean();
        this.portX = buf.readInt();
        this.portY = buf.readInt();
        this.portZ = buf.readInt();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.ejectFuel);
        buf.writeBoolean(this.dumpExcess);
        buf.writeInt(this.portX);
        buf.writeInt(this.portY);
        buf.writeInt(this.portZ);
    }

    public static class Handler
    extends ReactorMessageServer.Handler<ReactorCommandEjectToPortMessage> {
        @Override
        public IMessage handleMessage(ReactorCommandEjectToPortMessage message, MessageContext ctx, MultiblockReactor reactor) {
            CoordTriplet dest = new CoordTriplet(message.portX, message.portY, message.portZ);
            if (message.ejectFuel) {
                reactor.ejectFuel(message.dumpExcess, dest);
            } else {
                reactor.ejectWaste(message.dumpExcess, dest);
            }
            return null;
        }
    }
}

