/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import openperipheral.adapter.ArgumentDescriptionBase;
import openperipheral.adapter.IMethodDescription;
import openperipheral.adapter.property.IndexedTypeInfo;
import openperipheral.adapter.property.SimpleMethodDescription;
import openperipheral.adapter.property.SingleTypeInfo;
import openperipheral.adapter.types.AlternativeType;
import openperipheral.adapter.types.SingleType;
import openperipheral.adapter.types.TypeHelper;
import openperipheral.api.adapter.IScriptType;
import org.apache.commons.lang3.StringUtils;

public class PropertyDescriptionBuilder {
    private static final String ARG_VALUE = "value";
    private static final String ARG_INDEX = "index";
    private final String name;
    private final String capitalizedName;
    private final String source;
    private IScriptType singleValueType;
    private IScriptType indexKeyType;
    private IScriptType indexValueType;
    private boolean buildIndexedProperty;
    private boolean buildSingleProperty;
    private String description;

    public PropertyDescriptionBuilder(String name, String source) {
        this.name = name;
        this.capitalizedName = StringUtils.capitalize((String)name);
        this.source = source;
    }

    public void addSingleParameter(IScriptType singleType) {
        this.singleValueType = singleType;
        this.buildSingleProperty = true;
    }

    public void addSingleParameter(SingleTypeInfo singleTypeInfo) {
        this.addSingleParameter(singleTypeInfo.valueDocType);
    }

    public void addIndexParameter(IScriptType keyType, IScriptType valueType) {
        this.indexKeyType = keyType;
        this.indexValueType = valueType;
        this.buildIndexedProperty = true;
    }

    public void addIndexParameter(IndexedTypeInfo indexedTypeInfo) {
        this.addIndexParameter(indexedTypeInfo.keyDocType, indexedTypeInfo.valueDocType);
    }

    public void overrideDescription(String description) {
        this.description = description;
    }

    public IMethodDescription buildSetter() {
        String description = Strings.isNullOrEmpty((String)this.description) ? "Set field '" + this.name + "' value" : this.description;
        String methodName = "set" + this.capitalizedName;
        ArrayList arguments = Lists.newArrayList();
        IScriptType valueType = this.calculateValueType();
        arguments.add(new ArgumentDescriptionBase(ARG_VALUE, valueType, ""));
        if (this.buildIndexedProperty) {
            arguments.add(this.createIndexArgument());
        }
        return new SimpleMethodDescription(methodName, description, this.source, arguments, SingleType.VOID);
    }

    public IMethodDescription buildGetter() {
        String description = Strings.isNullOrEmpty((String)this.description) ? "Get field '" + this.name + "' value" : this.description;
        String methodName = "get" + this.capitalizedName;
        ArrayList arguments = Lists.newArrayList();
        if (this.buildIndexedProperty) {
            arguments.add(this.createIndexArgument());
        }
        IScriptType returnType = this.calculateValueType();
        return new SimpleMethodDescription(methodName, description, this.source, arguments, returnType);
    }

    private IScriptType calculateValueType() {
        if (this.buildIndexedProperty && this.buildSingleProperty) {
            if (TypeHelper.compareTypes(this.singleValueType, this.indexValueType)) {
                return this.singleValueType;
            }
            return new AlternativeType(this.singleValueType, this.indexValueType);
        }
        if (this.buildSingleProperty) {
            return this.singleValueType;
        }
        if (this.buildIndexedProperty) {
            return this.indexValueType;
        }
        throw new IllegalStateException("DERP?");
    }

    private IndexArgumentDescription createIndexArgument() {
        return new IndexArgumentDescription(ARG_INDEX, this.indexKeyType, "", this.buildSingleProperty);
    }

    private static class IndexArgumentDescription
    extends ArgumentDescriptionBase {
        private final boolean isOptional;

        private IndexArgumentDescription(String name, IScriptType type, String description, boolean isOptional) {
            super(name, type, description);
            this.isOptional = isOptional;
        }

        @Override
        public boolean optional() {
            return this.isOptional;
        }
    }
}

