/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import openperipheral.adapter.property.IIndexedFieldManipulator;
import openperipheral.adapter.property.PropertyUtils;
import openperipheral.api.adapter.IIndexedPropertyCallback;
import openperipheral.api.helpers.Index;
import openperipheral.api.property.IIndexedCustomProperty;
import openperipheral.converter.StructHandlerProvider;

public class IndexedManipulatorProvider {
    public static final IIndexedFieldManipulator ARRAY_MANIPULATOR = new ArrayFieldManipulator();
    public static final IIndexedFieldManipulator ARRAY_EXPANDING_MANIPULATOR = new ExpandingArrayFieldManipulator();
    public static final IIndexedFieldManipulator LIST_MANIPULATOR = new ListFieldManipulator();
    public static final IIndexedFieldManipulator LIST_EXPANDING_MANIPULATOR = new ExpandingListFieldManipulator();
    public static final IIndexedFieldManipulator MAP_MANIPULATOR = new MapFieldManipulator();
    public static final IIndexedFieldManipulator MAP_EXPANDING_MANIPULATOR = new ExpandingMapFieldManipulator();
    public static final IIndexedFieldManipulator INDEXED_OWNER_DELEGATING_MANIPULATOR = new IIndexedFieldManipulator(){

        @Override
        public void setField(Object owner, Object target, Field field, Object index, Object value) {
            ((IIndexedPropertyCallback)owner).setField(field, index, value);
        }

        @Override
        public Object getField(Object owner, Object target, Field field, Object index) {
            return ((IIndexedPropertyCallback)owner).getField(field, index);
        }
    };
    public static final IIndexedFieldManipulator INDEXED_TARGET_DELEGATING_MANIPULATOR = new GenericFieldManipulator<IIndexedCustomProperty<Object, Object>>(){

        @Override
        public void set(Object owner, IIndexedCustomProperty<Object, Object> target, Field field, Object index, Object value) {
            target.set(target, field, index, value);
        }

        @Override
        public Object get(Object owner, IIndexedCustomProperty<Object, Object> target, Field field, Object index) {
            return target.get(target, field, index);
        }
    };

    public static int getIndex(Object index) {
        Preconditions.checkArgument((boolean)(index instanceof Index), (String)"Invalid index type, got %s", (Object[])new Object[]{index.getClass()});
        return ((Index)index).value;
    }

    public static IIndexedFieldManipulator createStructManipulator(Class<?> cls) {
        StructHandlerProvider.IStructHandler handler = StructHandlerProvider.instance.getHandler(cls);
        return new StructFieldManipulator(handler);
    }

    public static IIndexedFieldManipulator getProvider(Class<?> fieldType, boolean isDelegating, boolean isExpanding) {
        if (isDelegating) {
            return INDEXED_OWNER_DELEGATING_MANIPULATOR;
        }
        if (IIndexedCustomProperty.class.isAssignableFrom(fieldType)) {
            return INDEXED_TARGET_DELEGATING_MANIPULATOR;
        }
        if (Map.class.isAssignableFrom(fieldType)) {
            return isExpanding ? MAP_EXPANDING_MANIPULATOR : MAP_MANIPULATOR;
        }
        if (List.class.isAssignableFrom(fieldType)) {
            return isExpanding ? LIST_EXPANDING_MANIPULATOR : LIST_MANIPULATOR;
        }
        if (fieldType.isArray()) {
            return isExpanding ? ARRAY_EXPANDING_MANIPULATOR : ARRAY_MANIPULATOR;
        }
        if (StructHandlerProvider.instance.isStruct(fieldType)) {
            return IndexedManipulatorProvider.createStructManipulator(fieldType);
        }
        throw new IllegalArgumentException("Failed to create manipulator for " + fieldType);
    }

    private static class StructFieldManipulator
    extends DefaultFieldManipulator {
        private final StructHandlerProvider.IStructHandler handler;

        public StructFieldManipulator(StructHandlerProvider.IStructHandler handler) {
            this.handler = handler;
        }

        private StructHandlerProvider.IFieldHandler getFieldHandler(Object index) {
            String key = index.toString();
            StructHandlerProvider.IFieldHandler fieldHandler = this.handler.field(key);
            Preconditions.checkNotNull((Object)fieldHandler, (String)"Invalid field name '%s'", (Object[])new Object[]{index});
            return fieldHandler;
        }

        @Override
        public void set(Object owner, Object target, Field field, Object index, Object value) {
            StructHandlerProvider.IFieldHandler fieldHandler = this.getFieldHandler(index);
            fieldHandler.set(target, value);
        }

        @Override
        public Object get(Object owner, Object target, Field field, Object index) {
            StructHandlerProvider.IFieldHandler fieldHandler = this.getFieldHandler(index);
            return fieldHandler.get(target);
        }
    }

    private static class ExpandingMapFieldManipulator
    extends MapFieldManipulator {
        private ExpandingMapFieldManipulator() {
        }

        @Override
        public void set(Object owner, Map<Object, Object> target, Field field, Object index, Object value) {
            target.put(index, value);
        }
    }

    private static class MapFieldManipulator
    extends GenericFieldManipulator<Map<Object, Object>> {
        private MapFieldManipulator() {
        }

        @Override
        public void set(Object owner, Map<Object, Object> target, Field field, Object index, Object value) {
            Preconditions.checkArgument((boolean)target.containsKey(index), (String)"Can't add new key '%s' to map", (Object[])new Object[]{index});
            target.put(index, value);
        }

        @Override
        public Object get(Object owner, Map<Object, Object> target, Field field, Object index) {
            return target.get(index);
        }
    }

    private static class ExpandingListFieldManipulator
    extends ListFieldManipulator {
        private ExpandingListFieldManipulator() {
        }

        @Override
        public void set(Object owner, List<Object> target, Field field, Object index, Object value) {
            int i = IndexedManipulatorProvider.getIndex(index);
            if (i < 0) {
                throw new IllegalArgumentException("Negative index: " + i);
            }
            while (i >= target.size()) {
                target.add(null);
            }
            target.set(i, value);
        }
    }

    private static class ListFieldManipulator
    extends GenericFieldManipulator<List<Object>> {
        private ListFieldManipulator() {
        }

        @Override
        public void set(Object owner, List<Object> target, Field field, Object index, Object value) {
            int i = IndexedManipulatorProvider.getIndex(index);
            try {
                target.set(i, value);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Failed to set value at index " + index);
            }
        }

        @Override
        public Object get(Object owner, List<Object> target, Field field, Object index) {
            int i = IndexedManipulatorProvider.getIndex(index);
            try {
                return target.get(i);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
    }

    private static class ExpandingArrayFieldManipulator
    extends ArrayFieldManipulator {
        private ExpandingArrayFieldManipulator() {
        }

        @Override
        public void set(Object owner, Object target, Field field, Object index, Object value) {
            int i = IndexedManipulatorProvider.getIndex(index);
            if (i < 0) {
                throw new IllegalArgumentException("Negative index: " + i);
            }
            int length = Array.getLength(target);
            if (i >= length) {
                Class<?> componentCls = target.getClass().getComponentType();
                int newLength = i + 1;
                Object newArray = Array.newInstance(componentCls, newLength);
                System.arraycopy(target, 0, newArray, 0, length);
                target = newArray;
                PropertyUtils.setContents(owner, field, target);
            }
            Array.set(target, i, value);
        }
    }

    private static class ArrayFieldManipulator
    extends DefaultFieldManipulator {
        private ArrayFieldManipulator() {
        }

        @Override
        public void set(Object owner, Object target, Field field, Object index, Object value) {
            int i = IndexedManipulatorProvider.getIndex(index);
            try {
                Array.set(target, i, value);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Failed to set value at index " + index);
            }
        }

        @Override
        public Object get(Object owner, Object target, Field field, Object index) {
            int i = IndexedManipulatorProvider.getIndex(index);
            try {
                return Array.get(target, i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }
    }

    private static abstract class DefaultFieldManipulator
    extends GenericFieldManipulator<Object> {
        private DefaultFieldManipulator() {
        }
    }

    private static abstract class GenericFieldManipulator<T>
    implements IIndexedFieldManipulator {
        private GenericFieldManipulator() {
        }

        @Override
        public final void setField(Object owner, Object target, Field field, Object index, Object value) {
            Preconditions.checkNotNull((Object)target, (Object)"Can't index nil value");
            this.set(owner, target, field, index, value);
        }

        public abstract void set(Object var1, T var2, Field var3, Object var4, Object var5);

        @Override
        public final Object getField(Object owner, Object target, Field field, Object index) {
            Preconditions.checkNotNull((Object)target, (Object)"Can't index nil value");
            return this.get(owner, target, field, index);
        }

        public abstract Object get(Object var1, T var2, Field var3, Object var4);
    }
}

