/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import mekanism.api.gas.GasStack;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.oredict.IOreDictEntry;
import minetweaker.api.player.IPlayer;
import minetweaker.mc1710.item.MCItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.ReflectionHelper;
import modtweaker2.mods.mekanism.gas.MCGasStack;
import modtweaker2.mods.thaumcraft.aspect.AspectStack;
import modtweaker2.mods.thaumcraft.aspect.MCAspectStack;
import modtweaker2.utils.TweakerPlugin;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class LogHelper {
    public static void logPrinted(IPlayer player) {
        if (player != null) {
            player.sendChat(MineTweakerImplementationAPI.platform.getMessage("List generated; see minetweaker.log in your minecraft dir"));
        }
    }

    public static void log(IPlayer player, String message) {
        if (player != null) {
            player.sendChat(MineTweakerImplementationAPI.platform.getMessage(message));
        }
    }

    public static void print(String string) {
        System.out.println(string);
        MineTweakerAPI.logCommand((String)string);
    }

    public static void logError(String message) {
        MineTweakerAPI.logError((String)("[ModTweaker2] " + message));
    }

    public static void logError(String message, Throwable exception) {
        MineTweakerAPI.logError((String)("[ModTweaker2] " + message), (Throwable)exception);
    }

    public static void logWarning(String message) {
        MineTweakerAPI.logWarning((String)("[ModTweaker2] " + message));
    }

    public static void logInfo(String message) {
        MineTweakerAPI.logInfo((String)("[ModTweaker2] " + message));
    }

    public static String getStackDescription(Object object) {
        if (object instanceof IIngredient) {
            return LogHelper.getStackDescription((IIngredient)object);
        }
        if (object instanceof ItemStack) {
            return new MCItemStack((ItemStack)object).toString();
        }
        if (object instanceof FluidStack) {
            return LogHelper.getStackDescription((FluidStack)object);
        }
        if (object instanceof Block) {
            return new MCItemStack(new ItemStack((Block)object, 1, 0)).toString();
        }
        if (TweakerPlugin.isLoaded("Mekanism") && object instanceof GasStack) {
            return new MCGasStack((GasStack)object).toString();
        }
        if (TweakerPlugin.isLoaded("Thaumcraft") && object instanceof AspectStack) {
            return new MCAspectStack((AspectStack)object).toString();
        }
        if (TweakerPlugin.isLoaded("Thaumcraft") && object instanceof AspectList) {
            LinkedList<AspectStack> stacks = new LinkedList<AspectStack>();
            for (Aspect a : ((AspectList)object).getAspects()) {
                stacks.add(new AspectStack(a, ((AspectList)object).getAmount(a)));
            }
            return LogHelper.getListDescription(stacks);
        }
        if (object instanceof String) {
            ArrayList ores = OreDictionary.getOres((String)((String)object));
            if (!ores.isEmpty()) {
                return "<ore:" + (String)object + ">";
            }
            return "\"" + (String)object + "\"";
        }
        if (object instanceof List) {
            return LogHelper.getListDescription((List)object);
        }
        if (object instanceof Object[]) {
            return LogHelper.getListDescription(Arrays.asList((Object[])object));
        }
        if (object != null) {
            return "\"" + object.toString() + "\"";
        }
        return "null";
    }

    public static String getStackDescription(IIngredient stack) {
        Object internalObject = stack.getInternal();
        if (internalObject instanceof ItemStack) {
            return LogHelper.getStackDescription((ItemStack)internalObject);
        }
        if (internalObject instanceof FluidStack) {
            return LogHelper.getStackDescription((FluidStack)internalObject);
        }
        if (internalObject instanceof IOreDictEntry) {
            return LogHelper.getStackDescription(((IOreDictEntry)internalObject).getName());
        }
        return "null";
    }

    public static String getStackDescription(FluidStack stack) {
        StringBuilder sb = new StringBuilder();
        sb.append("<liquid:").append(stack.getFluid().getName()).append('>');
        if (stack.amount > 1) {
            sb.append(" * ").append(stack.amount);
        }
        return sb.toString();
    }

    public static String getListDescription(List<?> objects) {
        StringBuilder sb = new StringBuilder();
        if (objects.isEmpty()) {
            sb.append("[]");
        } else {
            sb.append('[');
            for (Object object : objects) {
                if (object instanceof List) {
                    sb.append(LogHelper.getListDescription((List)object)).append(", ");
                    continue;
                }
                if (object instanceof Object[]) {
                    sb.append(LogHelper.getListDescription(Arrays.asList((Object[])object))).append(", ");
                    continue;
                }
                sb.append(LogHelper.getStackDescription(object)).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(']');
        }
        return sb.toString();
    }

    public static String getCraftingDescription(IRecipe recipe) {
        if (recipe instanceof ShapelessOreRecipe) {
            return LogHelper.getCraftingDescription((ShapelessOreRecipe)recipe);
        }
        if (recipe instanceof ShapedOreRecipe) {
            return LogHelper.getCraftingDescription((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapelessRecipes) {
            return LogHelper.getCraftingDescription((ShapelessRecipes)recipe);
        }
        if (recipe instanceof ShapedRecipes) {
            return LogHelper.getCraftingDescription((ShapedRecipes)recipe);
        }
        return recipe.toString();
    }

    public static String getCraftingDescription(ShapelessOreRecipe recipe) {
        return LogHelper.getListDescription(recipe.getInput());
    }

    public static String getCraftingDescription(ShapelessRecipes recipe) {
        return LogHelper.getListDescription(recipe.field_77579_b);
    }

    public static String getCraftingDescription(ShapedOreRecipe recipe) {
        int height = (Integer)ReflectionHelper.getObject(recipe, "width");
        int width = (Integer)ReflectionHelper.getObject(recipe, "height");
        Object[][] recipes = InputHelper.getMultiDimensionalArray(Object.class, recipe.getInput(), height, width);
        return LogHelper.getListDescription(Arrays.asList(recipes));
    }

    public static String getCraftingDescription(ShapedRecipes recipe) {
        ItemStack[][] recipes = InputHelper.getMultiDimensionalArray(ItemStack.class, recipe.field_77574_d, recipe.field_77577_c, recipe.field_77576_b);
        return LogHelper.getListDescription(Arrays.asList(recipes));
    }
}

