/*
 * Decompiled with CFR 0.152.
 */
package advsolar.utils;

import advsolar.api.IMTRecipeManager;
import advsolar.common.AdvancedSolarPanel;
import advsolar.utils.MTRecipeConfig;
import advsolar.utils.MTRecipeRecord;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MTRecipeManager
implements IMTRecipeManager {
    public static List<MTRecipeRecord> transformerRecipes = Lists.newArrayList();
    public static MTRecipeManager instance = new MTRecipeManager();
    public static ArrayList<String> defaultRecipeList = new ArrayList();
    private static Method getUniqueName_Item;
    private static Method getUniqueName_Block;
    public static boolean rawReflectionDone;

    public void addMTOreDict(String name, String output, int energy) {
        ArrayList inputs = OreDictionary.getOres((String)name);
        ArrayList outputs = OreDictionary.getOres((String)output);
        if (outputs.size() == 0) {
            return;
        }
        if (inputs.size() == 0) {
            return;
        }
        for (ItemStack inputIS : inputs) {
            for (ItemStack outputIS : outputs) {
                this.addMTRecipe(inputIS.func_77946_l(), outputIS.func_77946_l(), energy);
            }
        }
    }

    public void addMTOreDict(String input, ItemStack output, int energy) {
        ArrayList inputs = OreDictionary.getOres((String)input);
        for (ItemStack inputIS : inputs) {
            this.addMTRecipe(inputIS.func_77946_l(), output.func_77946_l(), energy);
        }
    }

    public void addMTOreDict(ItemStack input, String output, int energy) {
        ArrayList outputs = OreDictionary.getOres((String)output);
        if (outputs.size() == 0) {
            return;
        }
        for (ItemStack outputIS : outputs) {
            this.addMTRecipe(input.func_77946_l(), outputIS.func_77946_l(), energy);
        }
    }

    public void initRecipes() {
        transformerRecipes.clear();
        String configFilePath = AdvancedSolarPanel.configFileName.substring(0, AdvancedSolarPanel.configFileName.lastIndexOf(File.separatorChar) + 1);
        String tmpFileName = AdvancedSolarPanel.configFileName.substring(AdvancedSolarPanel.configFileName.lastIndexOf(File.separatorChar) + 1);
        String recipesFileName = tmpFileName.substring(0, tmpFileName.lastIndexOf("."));
        String recipesFileExt = tmpFileName.substring(tmpFileName.lastIndexOf("."));
        recipesFileName = recipesFileName + "_MTRecipes" + recipesFileExt;
        File file = new File(configFilePath, recipesFileName);
        transformerRecipes.clear();
        transformerRecipes.addAll(MTRecipeConfig.parse(file));
    }

    private static void lazyReflectionInit() {
        if (!rawReflectionDone) {
            try {
                getUniqueName_Item = GameData.class.getDeclaredMethod("getUniqueName", Item.class);
                getUniqueName_Block = GameData.class.getDeclaredMethod("getUniqueName", Block.class);
                getUniqueName_Item.setAccessible(true);
                getUniqueName_Block.setAccessible(true);
            }
            catch (Exception e) {
                AdvancedSolarPanel.addLog("Reflection failed. This is a fatal error and not recoverable");
                throw new RuntimeException(e);
            }
            rawReflectionDone = true;
        }
    }

    public static RawItemData getItemData(ItemStack is) {
        MTRecipeManager.lazyReflectionInit();
        try {
            Item i = is.func_77973_b();
            if (i instanceof ItemBlock) {
                Block b = Block.func_149634_a((Item)i);
                GameRegistry.UniqueIdentifier ui = (GameRegistry.UniqueIdentifier)getUniqueName_Block.invoke(null, b);
                return new RawItemData(ui.modId, ui.name);
            }
            GameRegistry.UniqueIdentifier ui = (GameRegistry.UniqueIdentifier)getUniqueName_Item.invoke(null, i);
            return new RawItemData(ui.modId, ui.name);
        }
        catch (Throwable t) {
            AdvancedSolarPanel.addLog("Reflection failed. Weird error, report it.");
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public void addMTRecipe(ItemStack inputItem, ItemStack outputItem, int energyPerOperation) {
        MTRecipeRecord recipeToAdd = new MTRecipeRecord();
        recipeToAdd.inputStack = inputItem.func_77946_l();
        recipeToAdd.outputStack = outputItem.func_77946_l();
        recipeToAdd.energyPerOperation = energyPerOperation;
        transformerRecipes.add(recipeToAdd);
    }

    static {
        rawReflectionDone = false;
    }

    public static class RawItemData {
        public final String modId;
        public final String itemName;

        public RawItemData(String id, String name) {
            this.modId = id;
            this.itemName = name;
        }
    }
}

