/*
 * Decompiled with CFR 0.152.
 */
package advsolar.common.tiles;

import advsolar.common.AdvancedSolarPanel;
import advsolar.common.container.ContainerMolecularTransformer;
import advsolar.common.tiles.TileEntityBase;
import advsolar.network.IReceiveServerEvents;
import advsolar.network.PacketChangeState;
import advsolar.utils.MTRecipeManager;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMolecularTransformer
extends TileEntityBase
implements IEnergyTile,
IWrenchable,
IInventory,
IEnergySink,
ISidedInventory,
INetworkDataProvider,
INetworkUpdateListener,
INetworkTileEntityEventListener,
IReceiveServerEvents {
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1, 1};
    private static final int[] slots_sides = new int[]{1};
    public static Random randomizer = new Random();
    public int ticker;
    public boolean initialized = false;
    private short facing = (short)2;
    public boolean addedToEnergyNet;
    private boolean created = false;
    public boolean doWork;
    public boolean waitOutputSlot;
    public ItemStack lastRecipeInput;
    public ItemStack lastRecipeOutput;
    public int lastRecipeEnergyUsed;
    public int lastRecipeEnergyPerOperation;
    public int lastRecipeNumber;
    private int machineTire;
    private ItemStack[] workSlots = new ItemStack[2];
    private int lastX;
    private int lastY;
    private int lastZ;
    private Boolean deactiveTimer = false;
    private int deactiveTicker = 0;
    private int deactiveTickrate = 40;
    private int energyTicker = 0;
    private int energyTickRate = 60;
    public short lastProgress;
    public int energyBuffer;
    private boolean isActive;
    private boolean prevActiveState;
    public int inputEU;
    public boolean loaded = false;
    private static List<String> fields = Arrays.asList(new String[0]);

    public TileEntityMolecularTransformer() {
        this.machineTire = Integer.MAX_VALUE;
        this.ticker = randomizer.nextInt(this.tickRate());
        this.lastX = this.field_145851_c;
        this.lastY = this.field_145848_d;
        this.lastZ = this.field_145849_e;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.func_145837_r() || !this.field_145850_b.func_72899_e(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return;
        }
        this.onLoaded();
    }

    public void func_145843_s() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.func_145843_s();
    }

    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
        this.loaded = true;
    }

    public void onChunkUnload() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnload();
    }

    public void onUnloaded() {
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
        this.loaded = false;
    }

    public void intialize() {
        this.updateVisibility();
        this.initialized = true;
        if (!this.addedToEnergyNet) {
            this.onLoaded();
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.initialized && this.field_145850_b != null) {
            this.intialize();
        }
        if (!AdvancedSolarPanel.isSimulating()) {
            return;
        }
        if (this.lastX != this.field_145851_c || this.lastZ != this.field_145849_e || this.lastY != this.field_145848_d) {
            this.lastX = this.field_145851_c;
            this.lastY = this.field_145848_d;
            this.lastZ = this.field_145849_e;
            this.onUnloaded();
            this.intialize();
        }
        this.flushSlots();
        if (!this.doWork && this.workSlots[0] != null) {
            if (this.canSmelt()) {
                this.workSlots[0].field_77994_a -= this.lastRecipeInput.field_77994_a;
                this.lastRecipeEnergyUsed = 0;
                this.waitOutputSlot = false;
                this.lastProgress = 0;
                this.doWork = true;
                this.deactiveTimer = false;
            }
        } else if (this.doWork) {
            if (this.energyBuffer > 0) {
                this.energyTicker = 0;
                if (!this.waitOutputSlot) {
                    this.setActive(true, true);
                }
            } else {
                ++this.energyTicker;
                if (this.energyTicker >= this.energyTickRate) {
                    this.energyTicker = 0;
                    if (this.isActive) {
                        this.setActive(false, true);
                    }
                }
            }
            this.energyBuffer = this.gainFuel(this.energyBuffer);
        }
        if (this.deactiveTimer.booleanValue()) {
            this.checkDeactivateMachine();
        }
    }

    public void checkDeactivateMachine() {
        if (this.deactiveTimer.booleanValue()) {
            ++this.deactiveTicker;
            if (this.deactiveTicker == this.deactiveTickrate) {
                this.deactiveTicker = 0;
                this.deactiveTimer = false;
                this.setActive(false, true);
            }
        }
    }

    private boolean canSmelt() {
        if (this.workSlots[0] == null) {
            return false;
        }
        for (int i = 0; i < MTRecipeManager.transformerRecipes.size(); ++i) {
            ItemStack tmpItemStack = MTRecipeManager.transformerRecipes.get((int)i).inputStack;
            if (!this.isItemEqual(this.workSlots[0], tmpItemStack)) continue;
            if (this.workSlots[1] != null) {
                if (this.isItemEqual(this.workSlots[1], MTRecipeManager.transformerRecipes.get((int)i).outputStack)) {
                    if (this.workSlots[1].field_77994_a + MTRecipeManager.transformerRecipes.get((int)i).outputStack.field_77994_a > this.workSlots[1].func_77976_d()) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (this.workSlots[0].field_77994_a < MTRecipeManager.transformerRecipes.get((int)i).inputStack.field_77994_a) {
                return false;
            }
            this.lastRecipeInput = MTRecipeManager.transformerRecipes.get((int)i).inputStack.func_77946_l();
            this.lastRecipeOutput = MTRecipeManager.transformerRecipes.get((int)i).outputStack.func_77946_l();
            this.lastRecipeEnergyPerOperation = MTRecipeManager.transformerRecipes.get((int)i).energyPerOperation;
            this.lastRecipeNumber = i;
            return true;
        }
        return false;
    }

    public int gainFuel(int energyPacket) {
        int energyLeft = energyPacket;
        if (energyPacket >= 0) {
            if (this.lastRecipeEnergyPerOperation - this.lastRecipeEnergyUsed > energyPacket) {
                energyLeft = 0;
                this.lastRecipeEnergyUsed += energyPacket;
            } else {
                energyLeft = energyPacket - (this.lastRecipeEnergyPerOperation - this.lastRecipeEnergyUsed);
                this.lastRecipeEnergyUsed = this.lastRecipeEnergyPerOperation;
                this.lastProgress = (short)100;
                this.waitOutputSlot = true;
                if (this.workSlots[1] != null) {
                    if (this.isItemEqual(this.lastRecipeOutput, this.workSlots[1])) {
                        if (this.workSlots[1].func_77976_d() >= this.workSlots[1].field_77994_a + this.lastRecipeOutput.field_77994_a) {
                            this.workSlots[1].field_77994_a += this.lastRecipeOutput.field_77994_a;
                            this.doWork = false;
                            this.deactiveTicker = 0;
                            this.deactiveTimer = true;
                            super.func_70296_d();
                            this.waitOutputSlot = false;
                        } else if (this.isActive()) {
                            this.setActive(false, true);
                        }
                    }
                } else {
                    this.workSlots[1] = this.lastRecipeOutput.func_77946_l();
                    this.doWork = false;
                    this.deactiveTicker = 0;
                    this.deactiveTimer = true;
                    this.waitOutputSlot = false;
                    super.func_70296_d();
                }
            }
        }
        this.updateProgress();
        return energyLeft;
    }

    private void updateProgress() {
        if (this.doWork) {
            float tmpProgress = (float)this.lastRecipeEnergyUsed / (float)this.lastRecipeEnergyPerOperation * 100.0f;
            this.lastProgress = (short)Math.round(tmpProgress);
            if (this.lastRecipeEnergyUsed == this.lastRecipeEnergyPerOperation) {
                this.lastProgress = (short)100;
            }
        } else {
            this.lastProgress = 0;
            if (this.isActive) {
                this.deactiveTicker = 0;
                this.deactiveTimer = true;
            }
        }
    }

    private void flushSlots() {
        if (this.workSlots[0] != null && this.workSlots[0].field_77994_a <= 0) {
            this.workSlots[0] = null;
        }
        if (this.workSlots[1] != null && this.workSlots[1].field_77994_a <= 0) {
            this.workSlots[1] = null;
        }
    }

    private boolean isItemEqual(ItemStack inputStack, ItemStack outputStack) {
        return inputStack.func_77973_b() == outputStack.func_77973_b() && inputStack.func_77960_j() == outputStack.func_77960_j();
    }

    public void updateVisibility() {
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        int i;
        super.func_145839_a(nbttagcompound);
        this.lastX = nbttagcompound.func_74762_e("lastX");
        this.lastY = nbttagcompound.func_74762_e("lastY");
        this.lastZ = nbttagcompound.func_74762_e("lastZ");
        this.doWork = nbttagcompound.func_74767_n("doWork");
        this.lastRecipeEnergyUsed = nbttagcompound.func_74762_e("lastRecipeEnergyUsed");
        this.lastRecipeEnergyPerOperation = nbttagcompound.func_74762_e("lastRecipeEnergyPerOperation");
        this.lastProgress = nbttagcompound.func_74765_d("lastProgress");
        NBTTagList nbttaglist_recipe = nbttagcompound.func_150295_c("Recipes", 10);
        for (i = 0; i < nbttaglist_recipe.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound_recipe = nbttaglist_recipe.func_150305_b(i);
            if (i == 0) {
                this.lastRecipeInput = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound_recipe);
            }
            if (i != 1) continue;
            this.lastRecipeOutput = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound_recipe);
        }
        if (this.lastRecipeInput == null || this.lastRecipeOutput == null) {
            this.lastRecipeNumber = 0;
            this.doWork = false;
            this.lastProgress = 0;
            this.lastRecipeEnergyUsed = 0;
        } else {
            i = this.searchRecipeNumber(this.lastRecipeInput, this.lastRecipeOutput);
            if (i < 0) {
                this.lastRecipeNumber = 0;
                this.doWork = false;
                this.lastProgress = 0;
                this.lastRecipeEnergyUsed = 0;
            } else {
                this.lastRecipeNumber = i;
            }
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.workSlots = new ItemStack[this.func_70302_i_()];
        for (int i2 = 0; i2 < nbttaglist.func_74745_c(); ++i2) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i2);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.workSlots.length) continue;
            this.workSlots[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public int searchRecipeNumber(ItemStack inputStack, ItemStack outputStack) {
        for (int i = 0; i < MTRecipeManager.transformerRecipes.size(); ++i) {
            ItemStack tmpInputStack = MTRecipeManager.transformerRecipes.get((int)i).inputStack;
            ItemStack tmpOutputStack = MTRecipeManager.transformerRecipes.get((int)i).outputStack;
            if (!this.isItemEqual(inputStack, tmpInputStack) || !this.isItemEqual(outputStack, tmpOutputStack)) continue;
            return i;
        }
        return -1;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        NBTTagList nbttaglist_recipe = new NBTTagList();
        nbttagcompound.func_74768_a("lastX", this.lastX);
        nbttagcompound.func_74768_a("lastY", this.lastY);
        nbttagcompound.func_74768_a("lastZ", this.lastZ);
        nbttagcompound.func_74757_a("doWork", this.doWork);
        nbttagcompound.func_74768_a("lastRecipeEnergyUsed", this.lastRecipeEnergyUsed);
        nbttagcompound.func_74768_a("lastRecipeEnergyPerOperation", this.lastRecipeEnergyPerOperation);
        nbttagcompound.func_74777_a("lastProgress", this.lastProgress);
        nbttagcompound.func_74768_a("lastRecipeNumber", this.lastRecipeNumber);
        NBTTagCompound nbttagcompound_recipe = new NBTTagCompound();
        if (this.lastRecipeInput != null) {
            nbttagcompound_recipe.func_74757_a("lastRecipeInput", true);
            this.lastRecipeInput.func_77955_b(nbttagcompound_recipe);
        } else {
            nbttagcompound_recipe.func_74757_a("lastRecipeInput", false);
        }
        nbttaglist_recipe.func_74742_a((NBTBase)nbttagcompound_recipe);
        nbttagcompound_recipe = new NBTTagCompound();
        if (this.lastRecipeOutput != null) {
            nbttagcompound_recipe.func_74757_a("lastRecipeOutput", true);
            this.lastRecipeOutput.func_77955_b(nbttagcompound_recipe);
        } else {
            nbttagcompound_recipe.func_74757_a("lastRecipeOutput", false);
        }
        nbttaglist_recipe.func_74742_a((NBTBase)nbttagcompound_recipe);
        nbttagcompound.func_74782_a("Recipes", (NBTBase)nbttaglist_recipe);
        for (int i = 0; i < this.workSlots.length; ++i) {
            if (this.workSlots[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.workSlots[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean activeState, boolean network) {
        if (network && activeState != this.isActive) {
            PacketChangeState.issue(this, activeState ? 1 : 0, null);
        }
        if (activeState != this.isActive) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.isActive = activeState;
        if (!activeState) {
            this.inputEU = 0;
        }
    }

    public int gaugeFuelScaled(int i) {
        return i;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int tickRate() {
        return 20;
    }

    @Override
    public short getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(short facing) {
        this.facing = facing;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityplayer, int i) {
        return false;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public ItemStack[] getContents() {
        return this.workSlots;
    }

    public int func_70302_i_() {
        return this.workSlots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.workSlots[i];
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack itemStack = this.func_70301_a(index);
        if (itemStack == null) {
            return null;
        }
        if (amount >= itemStack.field_77994_a) {
            this.func_70299_a(index, null);
            return itemStack;
        }
        itemStack.field_77994_a -= amount;
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = amount;
        return ret;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.workSlots[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer) {
        return new ContainerMolecularTransformer(inventoryplayer, this);
    }

    public ItemStack func_70304_b(int var1) {
        if (this.workSlots[var1] != null) {
            ItemStack var2 = this.workSlots[var1];
            this.workSlots[var1] = null;
            return var2;
        }
        return null;
    }

    public void onNetworkUpdate(String field) {
    }

    @Override
    public List<String> getNetworkedFields() {
        return fields;
    }

    @Override
    public void onServerEvent(int event, NBTTagCompound nbtData) {
        Thread.getAllStackTraces();
        switch (event) {
            case 0: {
                this.setActive(false, false);
                break;
            }
            case 1: {
                this.setActive(true, false);
            }
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.isActive = nbt.func_74767_n("active");
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74757_a("active", this.isActive);
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, nbttagcompound);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    public double getDemandedEnergy() {
        if (!this.doWork) {
            this.inputEU = 0;
            return 0.0;
        }
        if (this.lastRecipeEnergyPerOperation - this.lastRecipeEnergyUsed >= 0) {
            return this.lastRecipeEnergyPerOperation - this.lastRecipeEnergyUsed;
        }
        return 0.0;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        this.inputEU = (int)amount;
        if (!this.doWork) {
            return amount;
        }
        if ((double)(this.lastRecipeEnergyPerOperation - this.lastRecipeEnergyUsed) >= amount) {
            this.energyBuffer = (int)((double)this.energyBuffer + amount);
            return 0.0;
        }
        this.energyBuffer = (int)((double)this.energyBuffer + (amount - (double)(this.lastRecipeEnergyPerOperation - this.lastRecipeEnergyUsed)));
        return amount - (double)(this.lastRecipeEnergyPerOperation - this.lastRecipeEnergyUsed);
    }

    public int getSinkTier() {
        return this.machineTire;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 1 ? false : i == 0;
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? slots_bottom : (side == 1 ? slots_top : slots_sides);
    }

    public boolean func_102007_a(int index, ItemStack itemStack, int side) {
        return index != 1;
    }

    public boolean func_102008_b(int index, ItemStack itemStack, int side) {
        return true;
    }

    public String func_145825_b() {
        return "Molecular Transformer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

