/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.nei;

import codechicken.microblock.MicroMaterialRegistry;
import codechicken.microblock.MicroRecipe;
import codechicken.microblock.Saw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.rwtema.extrautils.multipart.FMPBase;
import com.rwtema.extrautils.nei.FMPMicroBlockRecipeCreator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;

@SideOnly(value=Side.CLIENT)
public class FMPMicroBlocksHandler
extends ShapedRecipeHandler {
    public static String[] currentMaterials = null;
    public static ItemStack[] currentBlocks = null;
    public static ArrayList<ShapedRecipes> recipes = null;
    public String currentMaterial = "";
    public ItemStack currentBlock = null;
    public boolean scroll = true;
    public static HashSet<ItemStack> sawList = null;
    public static final String identifier = "microblocks";

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        if (RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)identifier) || RecipeInfo.hasOverlayHandler((GuiContainer)gui, (String)identifier)) {
            return true;
        }
        if (this.isRecipe2x2(recipe) && RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)"microblocks2x2")) {
            return true;
        }
        return super.hasOverlay(gui, container, recipe);
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        IOverlayHandler handler = RecipeInfo.getOverlayHandler((GuiContainer)gui, (String)identifier);
        if (handler != null) {
            return handler;
        }
        if (this.isRecipe2x2(recipe) && (handler = RecipeInfo.getOverlayHandler((GuiContainer)gui, (String)"microblocks2x2")) != null) {
            return handler;
        }
        return super.getOverlayHandler(gui, recipe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashSet<ItemStack> getSawList() {
        if (sawList != null) return sawList;
        sawList = new HashSet();
        Class<ItemList> clazz = ItemList.class;
        synchronized (ItemList.class) {
            for (Item item : ItemList.itemMap.keySet()) {
                if (!(item instanceof Saw)) continue;
                for (ItemStack stack : ItemList.itemMap.get((Object)item)) {
                    sawList.add(stack);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sawList;
        }
    }

    public ItemStack[] getSaws() {
        if (this.scroll || "".equals(this.currentMaterial) || this.currentBlock == null) {
            return FMPMicroBlocksHandler.getSawList().toArray(new ItemStack[0]);
        }
        int p = MicroMaterialRegistry.getMaterial((String)this.currentMaterial).getCutterStrength();
        HashSet<ItemStack> s = new HashSet<ItemStack>();
        for (ItemStack saw : FMPMicroBlocksHandler.getSawList()) {
            int sawStrength = ((Saw)saw.func_77973_b()).getCuttingStrength(saw);
            if (sawStrength < p && sawStrength != MicroMaterialRegistry.getMaxCuttingStrength()) continue;
            s.add(saw);
        }
        return s.toArray(new ItemStack[s.size()]);
    }

    public static ArrayList<ShapedRecipes> getCraftingRecipes() {
        if (recipes == null || recipes.size() == 0) {
            recipes = FMPMicroBlockRecipeCreator.loadRecipes();
        }
        return recipes;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), identifier, new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(identifier)) {
            for (ShapedRecipes irecipe : FMPMicroBlocksHandler.getCraftingRecipes()) {
                MicroblockCachedRecipe recipe = new MicroblockCachedRecipe(irecipe);
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
            this.scroll = true;
            this.currentMaterial = "";
            this.currentBlock = null;
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (!result.func_77942_o() || "".equals(result.func_77978_p().func_74779_i("mat"))) {
            return;
        }
        MicroMaterialRegistry.IMicroMaterial m = MicroMaterialRegistry.getMaterial((String)result.func_77978_p().func_74779_i("mat"));
        if (m == null) {
            return;
        }
        this.scroll = false;
        this.currentMaterial = result.func_77978_p().func_74779_i("mat");
        this.currentBlock = m.getItem().func_77946_l();
        for (ShapedRecipes irecipe : FMPMicroBlocksHandler.getCraftingRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            MicroblockCachedRecipe recipe = new MicroblockCachedRecipe(irecipe);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        MicroMaterialRegistry.IMicroMaterial m;
        if (ingredient.func_77973_b() instanceof Saw) {
            this.scroll = true;
            this.currentMaterial = "";
            this.currentBlock = null;
        } else if (!ingredient.func_77942_o() || "".equals(ingredient.func_77978_p().func_74779_i("mat"))) {
            int id = MicroRecipe.findMaterial((ItemStack)ingredient);
            if (id < 0) {
                return;
            }
            m = MicroMaterialRegistry.getMaterial((int)id);
            if (m == null) {
                return;
            }
            this.scroll = false;
            this.currentMaterial = MicroMaterialRegistry.materialName((int)id);
            this.currentBlock = m.getItem().func_77946_l();
        } else {
            m = MicroMaterialRegistry.getMaterial((String)ingredient.func_77978_p().func_74779_i("mat"));
            if (m == null) {
                return;
            }
            this.scroll = false;
            this.currentMaterial = ingredient.func_77978_p().func_74779_i("mat");
            this.currentBlock = m.getItem().func_77946_l();
        }
        for (ShapedRecipes irecipe : FMPMicroBlocksHandler.getCraftingRecipes()) {
            MicroblockCachedRecipe recipe = new MicroblockCachedRecipe(irecipe);
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public String getRecipeName() {
        return "Microblock Crafting";
    }

    public class MicroblockCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public MicroblockPositionedStack result;

        public MicroblockCachedRecipe(int width, int height, Object[] items, ItemStack out) {
            super((TemplateRecipeHandler)FMPMicroBlocksHandler.this);
            this.result = new MicroblockPositionedStack(out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public MicroblockCachedRecipe(ShapedRecipes irecipe) {
            this(irecipe.field_77576_b, irecipe.field_77577_c, irecipe.field_77574_d, irecipe.func_77571_b());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (y * width + x > items.length || items[y * width + x] == null) continue;
                    ItemStack item = (ItemStack)items[y * width + x];
                    Object stack = item.func_77973_b() == FMPMicroBlockRecipeCreator.stone.func_77973_b() ? new MicroblockPositionedStack(item, 25 + x * 18, 6 + y * 18) : (item == FMPMicroBlockRecipeCreator.saw ? new PositionedStack((Object)FMPMicroBlocksHandler.this.getSaws(), 25 + x * 18, 6 + y * 18, false) : (item.func_77973_b() == FMPBase.getMicroBlockItemId() ? new MicroblockPositionedStack((ItemStack)items[y * width + x], 25 + x * 18, 6 + y * 18) : new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18)));
                    stack.setMaxSize(1);
                    this.ingredients.add((PositionedStack)stack);
                }
            }
        }

        public void permMaterial() {
            int i;
            if (!FMPMicroBlocksHandler.this.scroll) {
                return;
            }
            if (currentMaterials == null) {
                currentMaterials = new String[MicroMaterialRegistry.getIdMap().length];
                for (i = 0; i < MicroMaterialRegistry.getIdMap().length; ++i) {
                    FMPMicroBlocksHandler.currentMaterials[i] = (String)MicroMaterialRegistry.getIdMap()[i]._1();
                }
            }
            if (currentBlocks == null) {
                currentBlocks = new ItemStack[MicroMaterialRegistry.getIdMap().length];
                for (i = 0; i < MicroMaterialRegistry.getIdMap().length; ++i) {
                    FMPMicroBlocksHandler.currentBlocks[i] = ((MicroMaterialRegistry.IMicroMaterial)MicroMaterialRegistry.getIdMap()[i]._2()).getItem().func_77946_l();
                }
            }
            FMPMicroBlocksHandler.this.currentMaterial = currentMaterials[FMPMicroBlocksHandler.this.cycleticks / 20 % currentMaterials.length];
            FMPMicroBlocksHandler.this.currentBlock = currentBlocks[FMPMicroBlocksHandler.this.cycleticks / 20 % currentMaterials.length];
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(FMPMicroBlocksHandler.this.cycleticks / 20, this.ingredients);
        }

        public void randomRenderPermutation(PositionedStack stack, long cycle) {
            super.randomRenderPermutation(stack, cycle);
        }

        public PositionedStack getResult() {
            this.result.setPermutationToRender(0);
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }

        public class MicroblockPositionedStack
        extends PositionedStack {
            boolean materialTag;
            int stacksize;

            public MicroblockPositionedStack(ItemStack object, int x, int y) {
                super((Object)object, x, y, true);
                this.materialTag = false;
                this.stacksize = object.field_77994_a;
                this.item = this.items[0].func_77946_l();
                this.materialTag = this.item.func_77973_b() == FMPBase.getMicroBlockItemId() && this.item.func_77960_j() != 0 && this.item.func_77960_j() != 8;
                this.setPermutationToRender(0);
            }

            public void generatePermutations() {
            }

            public void setItem(ItemStack item) {
                if (item != null) {
                    this.item = item.func_77946_l();
                    this.items[0] = item.func_77946_l();
                } else {
                    this.item = null;
                }
            }

            public void setPermutationToRender(int index) {
                if (this.item == null) {
                    return;
                }
                MicroblockCachedRecipe.this.permMaterial();
                if (this.materialTag) {
                    this.addMaterial();
                } else {
                    this.items[0] = FMPMicroBlocksHandler.this.currentBlock.func_77946_l();
                    this.items[0].field_77994_a = this.stacksize;
                    this.item = this.items[0];
                }
                super.setPermutationToRender(0);
            }

            public void addMaterial() {
                NBTTagCompound tag = this.items[0].func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                tag.func_74778_a("mat", FMPMicroBlocksHandler.this.currentMaterial);
                this.items[0].func_77982_d(tag);
            }
        }
    }
}

