/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.schematics;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.Position;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SchematicHanging
extends SchematicEntity {
    private Item baseItem;

    public SchematicHanging(Item baseItem) {
        this.baseItem = baseItem;
    }

    @Override
    public void translateToBlueprint(Translation transform) {
        super.translateToBlueprint(transform);
        Position pos = new Position(this.entityNBT.func_74762_e("TileX"), this.entityNBT.func_74762_e("TileY"), this.entityNBT.func_74762_e("TileZ"));
        pos = transform.translate(pos);
        this.entityNBT.func_74768_a("TileX", (int)pos.x);
        this.entityNBT.func_74768_a("TileY", (int)pos.y);
        this.entityNBT.func_74768_a("TileZ", (int)pos.z);
    }

    @Override
    public void translateToWorld(Translation transform) {
        super.translateToWorld(transform);
        Position pos = new Position(this.entityNBT.func_74762_e("TileX"), this.entityNBT.func_74762_e("TileY"), this.entityNBT.func_74762_e("TileZ"));
        pos = transform.translate(pos);
        this.entityNBT.func_74768_a("TileX", (int)pos.x);
        this.entityNBT.func_74768_a("TileY", (int)pos.y);
        this.entityNBT.func_74768_a("TileZ", (int)pos.z);
    }

    @Override
    public void rotateLeft(IBuilderContext context) {
        super.rotateLeft(context);
        Position pos = new Position(this.entityNBT.func_74762_e("TileX"), this.entityNBT.func_74762_e("TileY"), this.entityNBT.func_74762_e("TileZ"));
        pos = context.rotatePositionLeft(pos);
        this.entityNBT.func_74768_a("TileX", (int)pos.x);
        this.entityNBT.func_74768_a("TileY", (int)pos.y);
        this.entityNBT.func_74768_a("TileZ", (int)pos.z);
        int direction = this.entityNBT.func_74771_c("Direction");
        direction = direction < 3 ? direction + 1 : 0;
        this.entityNBT.func_74768_a("Direction", direction);
    }

    @Override
    public void readFromWorld(IBuilderContext context, Entity entity) {
        super.readFromWorld(context, entity);
        if (this.baseItem == Items.field_151160_bD) {
            NBTTagCompound tag = this.entityNBT.func_74775_l("Item");
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (stack != null) {
                this.storedRequirements = new ItemStack[2];
                this.storedRequirements[0] = new ItemStack(this.baseItem);
                this.storedRequirements[1] = stack;
            } else {
                this.storedRequirements = new ItemStack[1];
                this.storedRequirements[0] = new ItemStack(this.baseItem);
            }
        } else {
            this.storedRequirements = new ItemStack[1];
            this.storedRequirements[0] = new ItemStack(this.baseItem);
        }
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context) {
        Position newPosition = new Position(this.entityNBT.func_74762_e("TileX"), this.entityNBT.func_74762_e("TileY"), this.entityNBT.func_74762_e("TileZ"));
        int dir = this.entityNBT.func_74762_e("Direction");
        for (Object o : context.world().field_72996_f) {
            Entity e = (Entity)o;
            if (!(e instanceof EntityHanging)) continue;
            EntityHanging h = (EntityHanging)e;
            Position existingPositon = new Position(h.field_146063_b, h.field_146064_c, h.field_146062_d);
            if (!existingPositon.isClose(newPosition, 0.1f) || dir != ((EntityHanging)e).field_82332_a) continue;
            return true;
        }
        return false;
    }
}

