/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.server;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import cpw.mods.fml.common.Loader;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.machine.invpanel.server.AbstractInventory;
import crazypants.enderio.machine.invpanel.server.DSUInventory;
import crazypants.enderio.machine.invpanel.server.DrawerGroupInventory;
import crazypants.enderio.machine.invpanel.server.NormalInventory;
import java.util.ArrayList;
import net.minecraft.inventory.ISidedInventory;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public abstract class InventoryFactory {
    private static final ArrayList<InventoryFactory> factories = new ArrayList();

    static AbstractInventory createInventory(NetworkedInventory ni) {
        for (InventoryFactory f : factories) {
            AbstractInventory ai = f.create(ni);
            if (ai == null) continue;
            return ai;
        }
        return new NormalInventory(ni);
    }

    abstract AbstractInventory create(NetworkedInventory var1);

    static {
        factories.add(new DSUFactory());
        if (Loader.isModLoaded((String)"StorageDrawers")) {
            factories.add(new DrawerFactory());
        }
    }

    static class DrawerFactory
    extends InventoryFactory {
        DrawerFactory() {
        }

        @Override
        AbstractInventory create(NetworkedInventory ni) {
            ISidedInventory inv = ni.getInventory();
            if (inv instanceof IDrawerGroup) {
                return new DrawerGroupInventory((IDrawerGroup)inv);
            }
            return null;
        }
    }

    static class DSUFactory
    extends InventoryFactory {
        DSUFactory() {
        }

        @Override
        AbstractInventory create(NetworkedInventory ni) {
            ISidedInventory inv = ni.getInventory();
            if (inv instanceof IDeepStorageUnit) {
                return new DSUInventory((IDeepStorageUnit)inv);
            }
            return null;
        }
    }
}

