/*
 * Decompiled with CFR 0.152.
 */
package mrcomputerghost.runicdungeons.utils;

import mrcomputerghost.runicdungeons.RunicDungeons;
import mrcomputerghost.runicdungeons.blocks.BlockBricks;
import mrcomputerghost.runicdungeons.blocks.BlockKeystone;
import mrcomputerghost.runicdungeons.blocks.BlockLamp;
import mrcomputerghost.runicdungeons.blocks.BlockRunicPillar;
import mrcomputerghost.runicdungeons.blocks.BlockSpikeTrap;
import mrcomputerghost.runicdungeons.blocks.BlockSurvivalBricks;
import mrcomputerghost.runicdungeons.blocks.RunicBlocks;
import mrcomputerghost.runicdungeons.dim.ChunkProviderDungeon;
import mrcomputerghost.runicdungeons.ench.EnchantHandler;
import mrcomputerghost.runicdungeons.events.RunicEventHandler;
import mrcomputerghost.runicdungeons.items.RunicItems;
import mrcomputerghost.runicdungeons.utils.ChestGenUtils;
import mrcomputerghost.runicdungeons.utils.PortalManager;
import mrcomputerghost.runicdungeons.world.WorldGenRunicDungeon;
import mrcomputerghost.runicdungeons.world.rooms.GenOre;
import net.minecraftforge.common.config.Configuration;

public class ConfigUtils {
    public static void loadMainConfig(Configuration config) {
        config.load();
        RunicDungeons.dimId = config.get("IDs", "dimId", -34, "Runic Dimension Id").getInt();
        RunicDungeons.biomeId = config.get("IDs", "biomeId", 78, "Dungeon Biome Id").getInt();
        RunicDungeons.jungleChance = config.get("Spawning", "jungleChance", 30, "Chance of Magic Chalk spawning in a Jungle Temple").getInt();
        RunicDungeons.desertChance = config.get("Spawning", "desertChance", 30, "Chance of Magic Chalk spawning in a Desert Temple").getInt();
        RunicDungeons.keyDungeonChance = config.get("Spawning", "keyDungeonChance", 0, "Chance of a Dungeon Key spawning in regular Dungeon Chests (You OP Little Cheat)").getInt();
        RunicDungeons.chalkDungeonChance = config.get("Spawning", "chalkDungeonChance", 0, "Chance of Magical Chalk spawning in regular Dungeon Chests").getInt();
        RunicEventHandler.strongChance = config.get("Spawning", "strongChance", 25, "Chance of mobs in Runic Dungeons spawning with Strength").getInt();
        RunicEventHandler.speedChance = config.get("Spawning", "speedChance", 25, "Chance of mobs in Runic Dungeons spawning with Speed").getInt();
        RunicDungeons.canWitherSpawn = config.get("Spawning", "canWitherSpawn", true, "Whether or not WitherBoss rooms can spawn in Runic Dungeons").getBoolean();
        RunicDungeons.canGuardianSpawn = config.get("Spawning", "canGuardianSpawn", true, "Whether or not Dungeon Guardian rooms can spawn in Runic Dungeons").getBoolean();
        RunicEventHandler.witherSkeletonChance = config.get("Spawning", "witherSkeletonChance", 15, "Chance of Wither Skeletons spawning in the dungeon. Out of 100. Set to -1 to disable.").getInt();
        ChunkProviderDungeon.dungeonMaxX = config.get("Spawning", "dungeonMaxX", 64, "Max Dungeon Chunk Value (x)\nSet this and dungeonMaxY to -1 for Infinite").getInt();
        ChunkProviderDungeon.dungeonMaxY = config.get("Spawning", "dungeonMaxY", 64, "Max Dungeon Chunk Value (y)\nSet this and dungeonMaxX to -1 for Infinite").getInt();
        WorldGenRunicDungeon.dungeonMobs = config.get("Spawning", "dungeonMobs", WorldGenRunicDungeon.dungeonMobs, "What mobs to allow spawning in the Runic Dungeons").getStringList();
        RunicDungeons.useConnected = config.get("Misc", "useConnected", true, "Enables Connected Textures").getBoolean();
        RunicDungeons.allowVillages = config.get("Misc", "allowVillages", true, "Whether or not Magical Chalk can spawn in Blacksmith Chests").getBoolean();
        RunicDungeons.allowChalk = config.get("Misc", "allowChalk", false, "Whether or not Magical Chalk can be used in place of a Magical Staff").getBoolean();
        RunicDungeons.dungeonMode = config.get("Dungeon", "dungeonMode", 2, "The mode for the Runic Dungeon Dimension\n1 = Easy\n2 = Normal (Default)\n3 = Hard").getInt();
        RunicEventHandler.allowTop = config.get("Dungeon", "allowTop", false, "Whether or not players are allowed to be on top of the Dungeon").getBoolean();
        RunicDungeons.opsOnly = config.get("Dungeon", "opsOnly", false, "Set to true to allow only Operators or Admins to create portals.").getBoolean();
        RunicEventHandler.allowFlight = config.get("Dungeon", "allowFlight", true, "Whether or not to allow flying in the Dungeons.").getBoolean();
        WorldGenRunicDungeon.allowTCLoot = config.get("Dungeon", "genTCLoot", true, "(If Thaumcraft is Loaded) Whether or not to generate Loot Urns and Crates in the Dungeon").getBoolean();
        WorldGenRunicDungeon.useOldChestSystem = config.get("Dungeon", "useOldChestSystem", false, "Whether or not to use the old Chest Generation system in the Dungeons").getBoolean();
        WorldGenRunicDungeon.allowSpawnKey = config.get("Dungeon", "allowSpawnKey", true, "Whether or not to enable the Spawn Key in the Runic Dungeons").getBoolean();
        WorldGenRunicDungeon.allowRoomKeys = config.get("Dungeon", "allowRoomKeys", true, "Whether or not to enable the Room Keys in the Runic Dungeons").getBoolean();
        GenOre.oreNames = config.get("Dungeon", "oreNames", GenOre.oreNames, "List of Ores to spawn in Ore Room\nFormat is: modid:unlocalizedname:weight").getStringList();
        RunicEventHandler.explosionOreChance = config.get("Dungeon", "explosionOreChance", 35, "The chance that an Ore in the Ore Room will explode upon being broken.").getInt();
        RunicDungeons.boots = config.get("Dungeon", "boots", new String[0], "List of items that the player can wear on their feet to cancel out the effect of Spike Traps\neg: minecraft:iron_boots\nSimply put 'all' to allow all footwear to cancel out trap damage.").getStringList();
        RunicBlocks.allowDemonicBricks = config.get("Blocks", "allowDemonicBricks", true, "Whether or not to enable Demonic Bricks").getBoolean();
        RunicBlocks.allowSurvivalBricks = config.get("Blocks", "allowSurvivalBricks", true, "Whether or not to enable Survival Runic Bricks").getBoolean();
        RunicBlocks.allowSurvivalLamp = config.get("Blocks", "allowSurvivalLamp", true, "Whether or not to enable Survival Runic Lamps").getBoolean();
        RunicBlocks.allowSurvivalPillar = config.get("Blocks", "allowSurvivalPillar", true, "Whether or not to enable Survival Runic Pillars").getBoolean();
        RunicBlocks.allowSurvivalDemonicBricks = config.get("Blocks", "allowSurvivalDemonicBricks", true, "Whether or not to enable Survival Demonic Bricks").getBoolean();
        RunicBlocks.allowRunicGlass = config.get("Blocks", "allowRunicGlass", true, "Whether or not to enable Runic Glass").getBoolean();
        RunicBlocks.allowObsidianBricks = config.get("Blocks", "allowObsidianBricks", true, "Whether or not to enable Obsidian-Infused Runic Bricks").getBoolean();
        RunicBlocks.allowObsidianGlass = config.get("Blocks", "allowObsidianGlass", true, "Whether or not to enable Obsidian-Infused Runic Bricks").getBoolean();
        RunicBlocks.allowChaoticSand = config.get("Blocks", "allowChaoticSand", true, "Whether or not to enable Chaotic Sands").getBoolean();
        RunicBlocks.allowWitherGlass = config.get("Blocks", "allowWitherGlass", true, "Whether or not to enable WitherProof Runic Glass").getBoolean();
        RunicBlocks.allowWitherBricks = config.get("Blocks", "allowWitherBricks", true, "Whether or not to enable WitherProof Runic Bricks").getBoolean();
        RunicBlocks.allowCompressedObsidian = config.get("Blocks", "allowCompressedObsidian", true, "Whether or not to enable Compressed Obsidian").getBoolean();
        RunicItems.allowAmuletSpeed = config.get("Items", "allowAmuletSpeed", false, "Whether or not to enable Amulet of the Wind").getBoolean();
        RunicItems.allowAmuletHaste = config.get("Items", "allowAmuletHaste", false, "Whether or not to enable Amulet of the Earth").getBoolean();
        if (config.hasKey("Items", "allowAmuletString")) {
            config.renameProperty("Items", "allowAmuletString", "allowAmuletStrong");
        }
        RunicItems.allowAmuletStrong = config.get("Items", "allowAmuletStrong", false, "Whether or not to enable Amulet of Strength").getBoolean();
        RunicItems.allowAmuletJump = config.get("Items", "allowAmuletJump", false, "Whether or not to enable Amulet of Leaping").getBoolean();
        RunicItems.allowAmuletRegen = config.get("Items", "allowAmuletRegen", false, "Whether or not to enable Amulet of Healing").getBoolean();
        RunicItems.allowAmuletResist = config.get("Items", "allowAmuletResist", false, "Whether or not to enable Ironskin Amulet").getBoolean();
        RunicItems.allowAmuletFResist = config.get("Items", "allowAmuletFResist", false, "Whether or not to enable Amulet of the Blaze").getBoolean();
        RunicItems.allowAmuletBreath = config.get("Items", "allowAmuletBreath", false, "Whether or not to enable Amulet of the Ocean").getBoolean();
        RunicItems.allowAmuletNVision = config.get("Items", "allowAmuletNVision", false, "Whether or not to enable Amulet of the Night").getBoolean();
        RunicItems.allowBeltArrow = config.get("Items", "allowBeltArrow", true, "Whether or not to enable Arrow Belt").getBoolean();
        RunicItems.allowBeltFly = config.get("Items", "allowBeltFly", true, "Whether or not to enable Belt of Air").getBoolean();
        RunicItems.allowBasicBelt = config.get("Items", "allowBasicBelt", true, "Whether or not to enable the Basic Belt Base").getBoolean();
        RunicItems.allowAdvancedBelt = config.get("Items", "allowAdvancedBelt", true, "Whether or not to enable the Advanced Belt Base").getBoolean();
        RunicItems.allowRider = config.get("Items", "allowRider", true, "Whether or not to enable Rider/Stacker").getBoolean();
        RunicItems.allowTrapRemover = config.get("Items", "allowTrapRemover", true, "Whether or not to enable the Trap Nullification Wand").getBoolean();
        EnchantHandler.enablePoisonThorns = config.getBoolean("enablePoisonThorns", "enchantments", true, "Whether or not to enable the Poisonous Barbs enchantment");
        EnchantHandler.poisonThornsId = config.getInt("poisonThornsId", "enchantments", 80, 50, 255, "The ID to use for the Poisonous Barbs enchantment");
        EnchantHandler.enableKnockbackThorns = config.getBoolean("enableKnockbackThorns", "enchantments", true, "Whether or not to enable the Retaliatory Kick enchantment");
        EnchantHandler.knockbackThornsId = config.getInt("knockbackThornsId", "enchantments", 81, 50, 255, "The ID to use for the Retalitatory Kick enchantment");
        EnchantHandler.enableFireThorns = config.getBoolean("enableFireThorns", "enchantments", true, "Whether or not to enable the Flaming Spikes enchantment");
        EnchantHandler.fireThornsId = config.getInt("fireThornsId", "enchantments", 82, 50, 255, "The ID to use for the Flaming Spikes enchantment");
        EnchantHandler.enableMagicResist = config.getBoolean("enableMagicResist", "enchantments", true, "Whether or not to enable the Magic Resistance enchantment");
        EnchantHandler.magicResistId = config.getInt("magicResistId", "enchantments", 83, 50, 255, "The ID to use for the Magic Resistance enchantment");
        config.save();
    }

    public static void loadChestConfig(Configuration items) {
        items.load();
        ChestGenUtils.bookLoot = items.get("ChestGeneration", "chestLootLibrary", ChestGenUtils.genDefaults(), "What items to generate in Runic Library chests. Note: May be changed to JSON in the future\nFormat is the following:\nmodid:item:metadata:minValue:maxValue:weight").getStringList();
        ChestGenUtils.cobbleLoot = items.get("ChestGeneration", "chestLootMain", ChestGenUtils.genDefaults(), "What items to generate in the 4 Spawners Room chests. Note: May be changed to JSON in the future\nFormat is the following:\nmodid:item:metadata:minValue:maxValue:weight").getStringList();
        ChestGenUtils.ironLoot = items.get("ChestGeneration", "chestLootBars", ChestGenUtils.genDefaults(), "What items to generate in the 2 Spawners with Iron Bars Room. Note: May be changed to JSON in the future\nFormat is the following:\nmodid:item:metadata:minValue:maxValue:weight").getStringList();
        ChestGenUtils.obsidianLoot = items.get("ChestGeneration", "chestLootObsidian", ChestGenUtils.genDefaults(), "What items to generate in the 2 Spawners with Obsidian Room. Note: May be changed to JSON in the future\nFormat is the following:\nmodid:item:metadata:minValue:maxValue:weight").getStringList();
        items.save();
    }

    public static void loadTexturesConfig(Configuration textures) {
        textures.load();
        BlockBricks.icons = textures.getStringList("Textures", "dungeonBlockIcons", BlockBricks.icons, "Icon to be used for Runic Bricks");
        BlockRunicPillar.icons = textures.getStringList("Textures", "pillarBlockIcons", BlockRunicPillar.icons, "Pillar top, side, and bottom textures to be used for Runic Dungeon Pillars");
        BlockKeystone.keystoneTexture = textures.getString("Textures", "keyholeBlockIcon", BlockKeystone.keystoneTexture, "Texture to be used for Runic Keyholes");
        BlockLamp.lampTexture = textures.getString("Textures", "lampBlockIcon", BlockLamp.lampTexture, "Texture to be used for Runic Lamps");
        BlockSpikeTrap.spikeTrapTexture = textures.getString("Textures", "spikeBlockIcon", BlockSpikeTrap.spikeTrapTexture, "Texture to get used for Spike Traps");
        BlockBricks.useAltBrickTextures = textures.get("Textures", "useAltBrickTextures", false, "Whether or not to use alternate 16x brick textures").getBoolean();
        BlockRunicPillar.useAltPillarTextures = textures.get("Textures", "useAltPillarTextures", false, "Whether or not to use alternate 16x pillar textures").getBoolean();
        BlockLamp.useAltLampTexture = textures.get("Textures", "useAltLampTexture", false, "Whether or not to use alternate 16x lamp texture").getBoolean();
        BlockKeystone.useAltKeystoneTexture = textures.get("Textures", "useAltKeyholeTexture", false, "Whether or not to use alternate 16x keystone texture").getBoolean();
        BlockSurvivalBricks.useAltSurvivalBrickTextures = textures.get("Textures", "useAltSurvivalBrickTextures", false, "Whether or not to use alternate 16x survival brick textures").getBoolean();
        BlockSpikeTrap.useAltSpikeTrapTexture = textures.get("Textures", "useAltSpikeTrapTextures", false, "Whether or not to use alternate 16x spike trap textures").getBoolean();
        textures.save();
    }

    public static void loadPortalConfig(Configuration portal) {
        portal.load();
        PortalManager.activatorItemS = portal.getString("Portal Components", "activatorItem", PortalManager.activatorItemS, "Item used to activate the Runic Dungeons portal. Format is: modid:name:metadata");
        PortalManager.innerBlockS = portal.getString("Portal Components", "innerBlock", PortalManager.innerBlockS, "Block used as an inner block for the Runic Dungeons portal. Format is: modid:name:metadata");
        PortalManager.outerBlockS = portal.getString("Portal Components", "outerBlock", PortalManager.outerBlockS, "Block used as an outer block for the Runic Dungeons portal. Format is: modid:name:metadata");
        portal.save();
    }
}

