/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.inventory;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.data.ModItems;
import com.xcompwiz.mystcraft.inventory.InventoryUtils;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import com.xcompwiz.mystcraft.treasure.WeightProviderSymbolItem;
import com.xcompwiz.mystcraft.utility.WeightedItemSelector;
import com.xcompwiz.mystcraft.villager.VillagerTradeSystem;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryVillager {
    private static final long step_size = 12000L;
    private boolean dirty;
    private long lastrestock;
    private long lastupdated;
    private EntityVillager villager;
    private Random rand = new Random();
    private ItemStack[] pageitems = new ItemStack[3];
    private int boostercount = 5;

    public InventoryVillager(EntityVillager villager) {
        this.villager = villager;
    }

    public Entity getVillager() {
        return this.villager;
    }

    public void markDirty() {
        this.setDirty(true);
    }

    public void setDirty(boolean b) {
        this.dirty = b;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public long getLastChanged() {
        return this.lastupdated;
    }

    private void markUpdated() {
        this.lastupdated = this.villager.field_70170_p.func_82737_E();
        this.markDirty();
    }

    public int getBoosterCount() {
        return this.boostercount;
    }

    public int getBoosterCost() {
        return 20;
    }

    public void simulate() {
        long deltatime = this.villager.field_70170_p.func_82737_E() - this.lastrestock;
        while (deltatime >= 12000L) {
            deltatime -= 12000L;
            this.lastrestock += 12000L;
            this.restock();
        }
    }

    private void restock() {
        int nonechance = 1;
        int boosterchance = 3;
        int roll = this.rand.nextInt(nonechance + boosterchance + this.pageitems.length);
        if ((roll -= nonechance) < 0) {
            return;
        }
        if ((roll -= boosterchance) < 0) {
            if (this.boostercount < 8) {
                ++this.boostercount;
                this.markUpdated();
            }
            return;
        }
        if (this.pageitems[roll] != null && this.pageitems[roll].field_77994_a < 5) {
            ++this.pageitems[roll].field_77994_a;
        }
        this.markUpdated();
    }

    public boolean purchaseBooster(InventoryPlayer inventoryplayer) {
        if (this.boostercount <= 0) {
            return false;
        }
        int playerEmeralds = this.getPlayerEmeralds(inventoryplayer);
        int price = this.getBoosterCost();
        ItemStack booster = new ItemStack(ModItems.booster);
        if (playerEmeralds < price) {
            return false;
        }
        if (!inventoryplayer.func_70441_a(booster)) {
            return false;
        }
        if (!this.deductPrice(inventoryplayer, price)) {
            InventoryUtils.removeFromInventory((IInventory)inventoryplayer, booster, 1);
            return false;
        }
        --this.boostercount;
        this.markUpdated();
        return true;
    }

    public boolean purchaseShopItem(InventoryPlayer inventoryplayer, int index) {
        ItemStack original = this.getShopItem(index);
        if (original == null) {
            return false;
        }
        ItemStack clone = original.func_77946_l();
        if (clone.field_77994_a <= 0) {
            return false;
        }
        clone.field_77994_a = 1;
        int price = this.getShopItemPrice(index);
        int playerEmeralds = this.getPlayerEmeralds(inventoryplayer);
        if (playerEmeralds < price) {
            return false;
        }
        if (!inventoryplayer.func_70441_a(clone)) {
            return false;
        }
        if (!this.deductPrice(inventoryplayer, price)) {
            InventoryUtils.removeFromInventory((IInventory)inventoryplayer, clone, 1);
            return false;
        }
        --original.field_77994_a;
        this.markUpdated();
        return true;
    }

    private boolean deductPrice(InventoryPlayer inventoryplayer, int price) {
        int playerchange = InventoryUtils.countInInventory((IInventory)inventoryplayer, new ItemStack(Items.field_151166_bC));
        if (playerchange < price % 9) {
            if (!inventoryplayer.func_70441_a(new ItemStack(Items.field_151166_bC, 9))) {
                return false;
            }
            InventoryUtils.removeFromInventory((IInventory)inventoryplayer, new ItemStack(Blocks.field_150475_bE), 1);
        }
        price = price % 9 + 9 * InventoryUtils.removeFromInventory((IInventory)inventoryplayer, new ItemStack(Blocks.field_150475_bE), price / 9);
        price = InventoryUtils.removeFromInventory((IInventory)inventoryplayer, new ItemStack(Items.field_151166_bC), price);
        return true;
    }

    public Integer getPlayerEmeralds(InventoryPlayer inventoryplayer) {
        return InventoryUtils.countInInventory((IInventory)inventoryplayer, new ItemStack(Items.field_151166_bC)) + 9 * InventoryUtils.countInInventory((IInventory)inventoryplayer, new ItemStack(Blocks.field_150475_bE));
    }

    public ItemStack getShopItem(int index) {
        if (this.pageitems[index] == null && !this.villager.field_70170_p.field_72995_K) {
            IAgeSymbol symbol2 = WeightedItemSelector.getRandomItem(new Random(), SymbolManager.getSymbolsByRank(index + 1, null), WeightProviderSymbolItem.instance);
            this.pageitems[index] = Page.createSymbolPage(symbol2.identifier());
            this.pageitems[index].field_77994_a = 3;
        }
        return this.pageitems[index];
    }

    public int getShopItemPrice(int index) {
        ItemStack itemstack = this.getShopItem(index);
        return VillagerTradeSystem.getCardCost(itemstack);
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74782_a("Inventory", (NBTBase)NBTUtils.writeInventoryArray(new NBTTagList(), this.pageitems));
        data.func_74768_a("boostercount", this.boostercount);
        data.func_74772_a("lastrestock", this.lastrestock);
    }

    public void readFromNBT(NBTTagCompound data) {
        NBTUtils.readInventoryArray(data.func_150295_c("Inventory", 10), this.pageitems);
        if (data.func_74764_b("boostercount")) {
            this.boostercount = data.func_74762_e("boostercount");
        }
        if (data.func_74764_b("lastrestock")) {
            this.lastrestock = data.func_74762_e("lastrestock");
        }
        for (int i = 0; i < this.pageitems.length; ++i) {
            this.getShopItem(i);
        }
        if (!this.villager.field_70170_p.field_72995_K) {
            this.markUpdated();
        }
    }
}

