/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.imc;

import com.xcompwiz.mystcraft.data.ModSymbolsFluids;
import com.xcompwiz.mystcraft.imc.IMCHandler;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.symbol.SymbolManager;
import cpw.mods.fml.common.event.FMLInterModComms;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class IMCBlacklistFluid
implements IMCHandler.IMCProcessor {
    @Override
    public void process(FMLInterModComms.IMCMessage message) {
        Fluid fluid = null;
        ItemStack itemstack = null;
        if (message.isStringMessage()) {
            LoggerUtils.info(String.format("Receiving fluid symbol blacklist request from [%s] for fluid %s", message.getSender(), message.getStringValue()), new Object[0]);
            String fluidname = message.getStringValue();
            if (fluidname != null) {
                fluid = FluidRegistry.getFluid((String)fluidname);
            }
            if (fluid == null) {
                return;
            }
            if (fluid.getBlock() == null) {
                return;
            }
            Block block = fluid.getBlock();
            byte meta = 0;
            if (block instanceof BlockFluidBase) {
                meta = (byte)((BlockFluidBase)block).getMaxRenderHeightMeta();
            }
            if ((itemstack = new ItemStack(block, 1, (int)meta)).func_77973_b() == null) {
                throw new RuntimeException("Invalid item form for block " + block.func_149739_a() + "with metadata " + meta);
            }
        }
        if (message.isItemStackMessage()) {
            itemstack = message.getItemStackValue();
            LoggerUtils.info(String.format("Receiving fluid symbol blacklist request from [%s] for fluid %s", message.getSender(), message.getItemStackValue().func_77977_a()), new Object[0]);
        }
        if (itemstack == null) {
            return;
        }
        String identifier = "ModMat_" + itemstack.func_77977_a();
        SymbolManager.blackListSymbol(identifier);
        ModSymbolsFluids.blacklist(fluid);
        LoggerUtils.info("Fluid blacklist request successful.", new Object[0]);
    }
}

