/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic;

import mcjty.lib.varia.BlockTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class LogicSlabBlock
extends GenericRFToolsBlock {
    public static int RENDERID_LOGICSLAB;

    public LogicSlabBlock(Material material, String name, Class<? extends TileEntity> tileEntityClass) {
        super(material, tileEntityClass, false);
        this.func_149663_c(name);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3f, 1.0f);
        this.setHorizRotation(true);
    }

    private int getInputStrength(World world, int x, int y, int z, int side) {
        int dir = Direction.field_71579_d[side];
        int xoffset = x + Direction.field_71583_a[dir];
        int zoffset = z + Direction.field_71581_b[dir];
        int power = world.func_72878_l(xoffset, y, zoffset, side);
        int wirePower = world.func_147439_a(xoffset, y, zoffset) == Blocks.field_150488_af ? world.func_72805_g(xoffset, y, zoffset) : 0;
        return power >= 15 ? power : Math.max(power, wirePower);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int meta;
        ForgeDirection k = BlockTools.getOrientationHoriz((int)(meta = world.func_72805_g(x, y, z)));
        int power = this.getInputStrength(world, x, y, z, k.ordinal());
        meta = BlockTools.setRedstoneSignalIn((int)meta, (power > 0 ? 1 : 0) != 0);
        world.func_72921_c(x, y, z, meta, 2);
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RENDERID_LOGICSLAB;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        ForgeDirection k = BlockTools.getOrientationHoriz((int)meta);
        switch (k) {
            case NORTH: 
            case SOUTH: {
                return side == 0 || side == 2;
            }
            case WEST: 
            case EAST: {
                return side == 1 || side == 3;
            }
        }
        return false;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int meta = blockAccess.func_72805_g(x, y, z);
        ForgeDirection k = BlockTools.getOrientationHoriz((int)meta);
        if (side == k.ordinal()) {
            return BlockTools.getRedstoneSignalOut((int)meta) ? 15 : 0;
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int meta = blockAccess.func_72805_g(x, y, z);
        ForgeDirection k = BlockTools.getOrientationHoriz((int)meta);
        if (side == k.ordinal()) {
            return BlockTools.getRedstoneSignalOut((int)meta) ? 15 : 0;
        }
        return 0;
    }

    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (side == ForgeDirection.UP.ordinal()) {
            return this.iconInd;
        }
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.iconBottom;
        }
        return this.iconSide;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal()) {
            return this.iconInd;
        }
        if (side == ForgeDirection.DOWN.ordinal()) {
            return this.iconBottom;
        }
        return this.iconSide;
    }
}

