/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimletconstruction;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Map;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import mcjty.lib.varia.BlockTools;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionConfiguration;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionSetup;
import mcjty.rftools.blocks.dimletconstruction.DimletWorkbenchContainer;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.rftools.items.dimlets.types.DimletCraftingTools;
import mcjty.rftools.items.dimlets.types.IDimletType;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DimletWorkbenchTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory {
    public static final String CMD_STARTEXTRACT = "startExtract";
    public static final String CMD_GETEXTRACTING = "getExtracting";
    public static final String CLIENTCMD_GETEXTRACTING = "getExtracting";
    public static final String CMD_SETAUTOEXTRACT = "setAutoExtract";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, DimletWorkbenchContainer.factory, 51);
    private int extracting = 0;
    private DimletKey idToExtract = null;
    private int inhibitCrafting = 0;
    private boolean autoExtract = false;

    public int getExtracting() {
        return this.extracting;
    }

    public boolean isAutoExtract() {
        return this.autoExtract;
    }

    public DimletWorkbenchTileEntity() {
        super(DimletConstructionConfiguration.WORKBENCH_MAXENERGY, DimletConstructionConfiguration.WORKBENCH_RECEIVEPERTICK);
    }

    public int[] func_94128_d(int side) {
        return DimletWorkbenchContainer.factory.getAccessibleSlots();
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return index == 0;
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return index == 1;
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack s = this.inventoryHelper.decrStackSize(index, amount);
        this.checkCrafting();
        return s;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        if (index < 2 || index > 7) {
            return;
        }
        this.checkCrafting();
    }

    private void checkCrafting() {
        if (this.inhibitCrafting == 0 && !this.checkDimletCrafting() && this.inventoryHelper.getStackInSlot(1) != null) {
            this.inventoryHelper.setInventorySlotContents(0, 1, null);
        }
    }

    public String func_145825_b() {
        return "Workbench Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    protected void checkStateServer() {
        if (this.extracting > 0) {
            --this.extracting;
            if (this.extracting == 0 && !this.doExtract()) {
                this.extracting = 10;
            }
            this.func_70296_d();
        } else if (this.autoExtract) {
            this.startExtracting();
        }
    }

    private boolean checkDimletCrafting() {
        ItemStack stackBase = this.inventoryHelper.getStackInSlot(2);
        if (stackBase == null) {
            return false;
        }
        ItemStack stackController = this.inventoryHelper.getStackInSlot(3);
        if (stackController == null) {
            return false;
        }
        ItemStack stackTypeController = this.inventoryHelper.getStackInSlot(6);
        if (stackTypeController == null) {
            return false;
        }
        ItemStack stackMemory = this.inventoryHelper.getStackInSlot(5);
        if (stackMemory == null) {
            return false;
        }
        ItemStack stackEnergy = this.inventoryHelper.getStackInSlot(4);
        if (stackEnergy == null) {
            return false;
        }
        ItemStack stackEssence = this.inventoryHelper.getStackInSlot(7);
        if (stackEssence == null) {
            return false;
        }
        DimletType type = DimletType.values()[stackTypeController.func_77960_j()];
        IDimletType itype = type.dimletType;
        DimletKey key = itype.attemptDimletCrafting(stackController, stackMemory, stackEnergy, stackEssence);
        if (key != null) {
            this.inventoryHelper.setInventorySlotContents(1, 1, KnownDimletConfiguration.makeKnownDimlet(key, this.field_145850_b));
            return true;
        }
        return false;
    }

    public void craftDimlet() {
        ++this.inhibitCrafting;
        this.inventoryHelper.decrStackSize(2, 1);
        this.inventoryHelper.decrStackSize(3, 1);
        this.inventoryHelper.decrStackSize(6, 1);
        this.inventoryHelper.decrStackSize(4, 1);
        this.inventoryHelper.decrStackSize(5, 1);
        this.inventoryHelper.decrStackSize(7, 1);
        --this.inhibitCrafting;
        this.checkCrafting();
    }

    private void startExtracting() {
        DimletKey key;
        DimletEntry entry;
        if (this.extracting > 0) {
            return;
        }
        ItemStack stack = this.inventoryHelper.getStackInSlot(0);
        if (stack != null && ((Object)((Object)DimletSetup.knownDimlet)).equals(stack.func_77973_b()) && (entry = KnownDimletConfiguration.getEntry(key = KnownDimletConfiguration.getDimletKey(stack, this.field_145850_b))) != null && !KnownDimletConfiguration.craftableDimlets.contains(key)) {
            this.extracting = 64;
            this.idToExtract = key;
            this.inventoryHelper.decrStackSize(0, 1);
            this.func_70296_d();
        }
    }

    private boolean doExtract() {
        int rf = DimletConstructionConfiguration.rfExtractOperation;
        if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
            return false;
        }
        this.consumeEnergy(rf);
        float factor = this.getInfusedFactor();
        DimletEntry entry = KnownDimletConfiguration.getEntry(this.idToExtract);
        if (this.extractSuccess(factor)) {
            this.mergeItemOrThrowInWorld(new ItemStack((Item)DimletConstructionSetup.dimletBaseItem));
        }
        int rarity = entry.getRarity();
        if (this.extractSuccess(factor)) {
            this.mergeItemOrThrowInWorld(new ItemStack((Item)DimletConstructionSetup.dimletTypeControllerItem, 1, entry.getKey().getType().ordinal()));
        }
        int level = DimletCraftingTools.calculateItemLevelFromRarity(rarity);
        if (this.extractSuccess(factor)) {
            this.mergeItemOrThrowInWorld(new ItemStack((Item)DimletConstructionSetup.dimletMemoryUnitItem, 1, level));
        } else {
            factor += 0.1f;
        }
        if (this.extractSuccess(factor)) {
            this.mergeItemOrThrowInWorld(new ItemStack((Item)DimletConstructionSetup.dimletEnergyModuleItem, 1, level));
        } else {
            factor += 0.1f;
        }
        if (this.extractSuccess(factor)) {
            this.mergeItemOrThrowInWorld(new ItemStack((Item)DimletConstructionSetup.dimletControlCircuitItem, 1, rarity));
        }
        this.idToExtract = null;
        this.func_70296_d();
        return true;
    }

    private boolean extractSuccess(float factor) {
        return this.field_145850_b.field_73012_v.nextFloat() <= 0.61f + factor * 0.4f;
    }

    private void mergeItemOrThrowInWorld(ItemStack stack) {
        int notInserted = InventoryHelper.mergeItemStack((IInventory)this, (boolean)false, (ItemStack)stack, (int)8, (int)50, null);
        if (notInserted > 0) {
            BlockTools.spawnItemStack((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ItemStack)stack);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        int id;
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.extracting = tagCompound.func_74762_e("extracting");
        this.idToExtract = null;
        if (tagCompound.func_74764_b("extDkey")) {
            DimletType type = DimletType.getTypeByOpcode(tagCompound.func_74779_i("extKtype"));
            this.idToExtract = new DimletKey(type, tagCompound.func_74779_i("extDkey"));
        } else if (tagCompound.func_74764_b("idToExtract") && (id = tagCompound.func_74762_e("idToExtract")) != -1) {
            DimletMapping mapping = DimletMapping.getDimletMapping(this.field_145850_b);
            this.idToExtract = mapping.getKey(id);
        }
        this.autoExtract = tagCompound.func_74767_n("autoExtract");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74768_a("extracting", this.extracting);
        if (this.idToExtract != null) {
            tagCompound.func_74778_a("extKtype", this.idToExtract.getType().dimletType.getOpcode());
            tagCompound.func_74778_a("extDkey", this.idToExtract.getName());
        }
        tagCompound.func_74757_a("autoExtract", this.autoExtract);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_STARTEXTRACT.equals(command)) {
            this.startExtracting();
            return true;
        }
        if (CMD_SETAUTOEXTRACT.equals(command)) {
            this.autoExtract = args.get("auto").getBoolean();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public void requestExtractingFromServer() {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer(this.field_145851_c, this.field_145848_d, this.field_145849_e, "getExtracting", "getExtracting", new Argument[0]));
    }

    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getExtracting".equals(command)) {
            return this.extracting;
        }
        return null;
    }

    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getExtracting".equals(command)) {
            this.extracting = result;
            return true;
        }
        return false;
    }
}

