/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityDynamo;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWatermill
extends TileEntityIEBase {
    public int facing = 2;
    public int[] offset = new int[]{0, 0};
    public float rotation = 0.0f;
    private Vec3 rotationVec = null;
    public boolean canTurn = false;
    public boolean multiblock = false;
    public float prevRotation = 0.0f;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public void func_145845_h() {
        if (this.offset[0] != 0 || this.offset[1] != 0) {
            return;
        }
        if (this.isBlocked()) {
            this.canTurn = false;
            return;
        }
        boolean bl = this.canTurn = this.getRotationVec().func_72433_c() != 0.0;
        if (!this.multiblock && this.field_145850_b.func_82737_E() % 256L == (long)((this.field_145851_c ^ this.field_145849_e) & 0xFF)) {
            this.rotationVec = null;
        }
        this.prevRotation = this.rotation;
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
        if (this.field_145850_b.func_147438_o(this.field_145851_c - fd.offsetX, this.field_145848_d, this.field_145849_e - fd.offsetZ) instanceof TileEntityDynamo && !this.multiblock) {
            double power = this.getPower();
            int l = 1;
            TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX * l, this.field_145848_d, this.field_145849_e + fd.offsetZ * l);
            while (l < 3 && this.canUse(tileEntity)) {
                power += ((TileEntityWatermill)tileEntity).getPower();
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX * ++l, this.field_145848_d, this.field_145849_e + fd.offsetZ * l);
            }
            double perTick = 6.944444612599909E-4 * power / (double)l;
            this.canTurn = perTick != 0.0;
            this.rotation = (float)((double)this.rotation + perTick);
            this.rotation %= 1.0f;
            for (int l2 = 1; l2 < l; ++l2) {
                tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX * l2, this.field_145848_d, this.field_145849_e + fd.offsetZ * l2);
                if (!(tileEntity instanceof TileEntityWatermill)) continue;
                ((TileEntityWatermill)tileEntity).rotation = this.rotation;
                ((TileEntityWatermill)tileEntity).canTurn = this.canTurn;
                ((TileEntityWatermill)tileEntity).multiblock = true;
            }
            if (!this.field_145850_b.field_72995_K) {
                TileEntityDynamo dynamo = (TileEntityDynamo)this.field_145850_b.func_147438_o(this.field_145851_c - fd.offsetX, this.field_145848_d - fd.offsetY, this.field_145849_e - fd.offsetZ);
                if ((this.facing == 2 || this.facing == 3) && dynamo.facing != 2 && dynamo.facing != 3) {
                    return;
                }
                if ((this.facing == 4 || this.facing == 5) && dynamo.facing != 4 && dynamo.facing != 5) {
                    return;
                }
                dynamo.inputRotation(Math.abs(power * 0.75), ForgeDirection.OPPOSITES[this.facing]);
            }
        } else if (!this.multiblock) {
            double perTick = 6.944444612599909E-4 * this.getPower();
            this.canTurn = perTick != 0.0;
            this.rotation = (float)((double)this.rotation + perTick);
            this.rotation %= 1.0f;
        }
        if (this.multiblock) {
            this.multiblock = false;
        }
    }

    private boolean canUse(TileEntity tileEntity) {
        if (!(tileEntity instanceof TileEntityWatermill)) {
            return false;
        }
        TileEntityWatermill wm = (TileEntityWatermill)tileEntity;
        return wm.offset[0] == 0 && wm.offset[1] == 0 && (wm.facing == this.facing || wm.facing == ForgeDirection.OPPOSITES[this.facing]) && !wm.isBlocked() && !wm.multiblock;
    }

    public boolean isBlocked() {
        for (ForgeDirection fdY : new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN}) {
            ForgeDirection[] forgeDirectionArray;
            if (this.facing <= 3) {
                ForgeDirection[] forgeDirectionArray2 = new ForgeDirection[2];
                forgeDirectionArray2[0] = ForgeDirection.EAST;
                forgeDirectionArray = forgeDirectionArray2;
                forgeDirectionArray2[1] = ForgeDirection.WEST;
            } else {
                ForgeDirection[] forgeDirectionArray3 = new ForgeDirection[2];
                forgeDirectionArray3[0] = ForgeDirection.SOUTH;
                forgeDirectionArray = forgeDirectionArray3;
                forgeDirectionArray3[1] = ForgeDirection.NORTH;
            }
            for (ForgeDirection fdW : forgeDirectionArray) {
                Block b = this.field_145850_b.func_147439_a(this.field_145851_c + fdW.offsetX * 2, this.field_145848_d + fdY.offsetY * 2, this.field_145849_e + fdW.offsetZ * 2);
                if (b.isSideSolid((IBlockAccess)this.field_145850_b, this.field_145851_c + fdW.offsetX * 2, this.field_145848_d + fdY.offsetY * 2, this.field_145849_e + fdW.offsetZ * 2, fdW.getOpposite())) {
                    return true;
                }
                if (!b.isSideSolid((IBlockAccess)this.field_145850_b, this.field_145851_c + fdW.offsetX * 2, this.field_145848_d + fdY.offsetY * 2, this.field_145849_e + fdW.offsetZ * 2, fdY.getOpposite())) continue;
                return true;
            }
        }
        return false;
    }

    public double getPower() {
        return this.facing <= 3 ? -this.getRotationVec().field_72450_a : this.getRotationVec().field_72449_c;
    }

    public void resetRotationVec() {
        this.rotationVec = null;
    }

    public Vec3 getRotationVec() {
        if (this.rotationVec == null) {
            this.rotationVec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
            this.rotationVec = Utils.addVectors(this.rotationVec, this.getHorizontalVec());
            this.rotationVec = Utils.addVectors(this.rotationVec, this.getVerticalVec());
        }
        return this.rotationVec;
    }

    Vec3 getHorizontalVec() {
        Vec3 dir = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.field_145851_c - (this.facing <= 3 ? 1 : 0), this.field_145848_d + 3, this.field_145849_e - (this.facing <= 3 ? 0 : 1)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.field_145851_c + (this.facing <= 3 ? 1 : 0), this.field_145848_d + 3, this.field_145849_e + (this.facing <= 3 ? 0 : 1)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.field_145851_c - (this.facing <= 3 ? 2 : 0), this.field_145848_d + 2, this.field_145849_e - (this.facing <= 3 ? 0 : 2)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.field_145850_b, this.field_145851_c + (this.facing <= 3 ? 2 : 0), this.field_145848_d + 2, this.field_145849_e + (this.facing <= 3 ? 0 : 2)));
        dir = Utils.getFlowVector(this.field_145850_b, this.field_145851_c - (this.facing <= 3 ? 2 : 0), this.field_145848_d - 2, this.field_145849_e - (this.facing <= 3 ? 0 : 2)).func_72444_a(dir);
        dir = Utils.getFlowVector(this.field_145850_b, this.field_145851_c + (this.facing <= 3 ? 2 : 0), this.field_145848_d - 2, this.field_145849_e + (this.facing <= 3 ? 0 : 2)).func_72444_a(dir);
        dir = Utils.getFlowVector(this.field_145850_b, this.field_145851_c - (this.facing <= 3 ? 1 : 0), this.field_145848_d - 3, this.field_145849_e - (this.facing <= 3 ? 0 : 1)).func_72444_a(dir);
        dir = Utils.getFlowVector(this.field_145850_b, this.field_145851_c, this.field_145848_d - 3, this.field_145849_e).func_72444_a(dir);
        dir = Utils.getFlowVector(this.field_145850_b, this.field_145851_c + (this.facing <= 3 ? 1 : 0), this.field_145848_d - 3, this.field_145849_e + (this.facing <= 3 ? 0 : 1)).func_72444_a(dir);
        return dir;
    }

    Vec3 getVerticalVec() {
        Vec3 dir = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Vec3 dirNeg = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.field_145851_c - (this.facing <= 3 ? 2 : 0), this.field_145848_d + 2, this.field_145849_e - (this.facing <= 3 ? 0 : 2)));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.field_145851_c - (this.facing <= 3 ? 3 : 0), this.field_145848_d + 1, this.field_145849_e - (this.facing <= 3 ? 0 : 3)));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.field_145851_c - (this.facing <= 3 ? 3 : 0), this.field_145848_d + 0, this.field_145849_e - (this.facing <= 3 ? 0 : 3)));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.field_145851_c - (this.facing <= 3 ? 3 : 0), this.field_145848_d - 1, this.field_145849_e - (this.facing <= 3 ? 0 : 3)));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.field_145850_b, this.field_145851_c - (this.facing <= 3 ? 2 : 0), this.field_145848_d - 2, this.field_145849_e - (this.facing <= 3 ? 0 : 2)));
        Vec3 dirPos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.field_145851_c + (this.facing <= 3 ? 2 : 0), this.field_145848_d + 2, this.field_145849_e + (this.facing <= 3 ? 0 : 2)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.field_145851_c + (this.facing <= 3 ? 3 : 0), this.field_145848_d + 1, this.field_145849_e + (this.facing <= 3 ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.field_145851_c + (this.facing <= 3 ? 3 : 0), this.field_145848_d + 0, this.field_145849_e + (this.facing <= 3 ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.field_145851_c + (this.facing <= 3 ? 3 : 0), this.field_145848_d - 1, this.field_145849_e + (this.facing <= 3 ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.field_145850_b, this.field_145851_c + (this.facing <= 3 ? 2 : 0), this.field_145848_d - 2, this.field_145849_e + (this.facing <= 3 ? 0 : 2)));
        if (this.facing <= 3) {
            dir.field_72450_a += dirNeg.field_72448_b;
            dir.field_72450_a -= dirPos.field_72448_b;
        } else {
            dir.field_72449_c += dirNeg.field_72448_b;
            dir.field_72449_c -= dirPos.field_72448_b;
        }
        return dir;
    }

    public static boolean _Immovable() {
        return true;
    }

    public boolean func_145842_c(int id, int arg) {
        this.rotationVec = Vec3.func_72443_a((double)((float)id / 10000.0f), (double)0.0, (double)((float)arg / 10000.0f));
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = nbt.func_74762_e("facing");
        this.prevRotation = nbt.func_74760_g("prevRotation");
        this.offset = nbt.func_74759_k("offset");
        this.rotation = nbt.func_74760_g("rotation");
        if (this.offset == null || this.offset.length < 2) {
            this.offset = new int[]{0, 0};
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74776_a("prevRotation", this.prevRotation);
        nbt.func_74783_a("offset", this.offset);
        nbt.func_74776_a("rotation", this.rotation);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offset[0] == 0 && this.offset[1] == 0 ? AxisAlignedBB.func_72330_a((double)(this.field_145851_c - (this.facing <= 3 ? 2 : 0)), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - (this.facing <= 3 ? 0 : 2)), (double)(this.field_145851_c + (this.facing <= 3 ? 3 : 0)), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + (this.facing <= 3 ? 0 : 3))) : AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        }
        return this.renderAABB;
    }

    public double func_145833_n() {
        return super.func_145833_n() * Config.getDouble("increasedTileRenderdistance");
    }
}

