/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBottlingMachine;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class MultiblockBottlingMachine
implements MultiblockHandler.IMultiblock {
    public static MultiblockBottlingMachine instance = new MultiblockBottlingMachine();
    static ItemStack[][][] structure = new ItemStack[2][2][3];
    private static final TileEntityBottlingMachine bottle = new TileEntityBottlingMachine();

    @Override
    public ItemStack[][][] getStructureManual() {
        structure = new ItemStack[2][2][3];
        for (int h = 0; h < 2; ++h) {
            for (int l = 0; l < 2; ++l) {
                for (int w = 0; w < 3; ++w) {
                    MultiblockBottlingMachine.structure[h][l][w] = l == 0 && w == 1 ? new ItemStack((Block)IEContent.blockMetalDecoration, 1, 7) : (h == 0 ? new ItemStack((Block)IEContent.blockMetalDecoration, 1, 1) : new ItemStack((Block)IEContent.blockMetalDevice, 1, 11));
                }
            }
        }
        return structure;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        if (iterator == 6 || iterator == 9) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (iterator == 8) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
        ClientUtils.bindAtlas(0);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ClientUtils.tes().func_78382_b();
        ClientUtils.tes().func_78373_b(-0.5, -1.5, -0.5);
        ClientUtils.handleStaticTileRenderer(bottle, false);
        ClientUtils.tes().func_78381_a();
        ClientUtils.tes().func_78373_b(0.0, 0.0, 0.0);
        TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)bottle, -0.5, -1.5, -0.5, 0.0f);
    }

    @Override
    public float getManualScale() {
        return 15.0f;
    }

    @Override
    public String getUniqueName() {
        return "IE:BottlingMachine";
    }

    @Override
    public boolean isBlockTrigger(Block b, int meta) {
        return b == IEContent.blockMetalDevice && meta == 11;
    }

    @Override
    public boolean createStructure(World world, int x, int y, int z, int side, EntityPlayer player) {
        boolean mirrored;
        int startZ;
        int startY;
        int startX;
        boolean b;
        if (side == 0 || side == 1) {
            int f;
            int playerViewQuarter = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            side = f = playerViewQuarter == 0 ? 2 : (playerViewQuarter == 1 ? 5 : (playerViewQuarter == 2 ? 3 : 4));
        }
        if (!(b = this.structureCheck(world, startX = x, startY = y, startZ = z, side, mirrored = false))) {
            mirrored = true;
            b = this.structureCheck(world, startX, startY, startZ, side, mirrored);
        }
        if (b) {
            for (int h = -1; h <= 0; ++h) {
                for (int l = 0; l < 2; ++l) {
                    for (int w = -1; w <= 1; ++w) {
                        int ww;
                        int n = ww = mirrored ? -w : w;
                        int xx = startX + (side == 4 ? l : (side == 5 ? -l : (side == 2 ? -ww : ww)));
                        int yy = startY + h;
                        int zz = startZ + (side == 2 ? l : (side == 3 ? -l : (side == 5 ? -ww : ww)));
                        world.func_147465_d(xx, yy, zz, (Block)IEContent.blockMetalMultiblocks, 12, 3);
                        TileEntity curr = world.func_147438_o(xx, yy, zz);
                        if (!(curr instanceof TileEntityBottlingMachine)) continue;
                        TileEntityBottlingMachine tile = (TileEntityBottlingMachine)curr;
                        tile.facing = side;
                        tile.mirrored = mirrored;
                        tile.formed = true;
                        tile.pos = (h + 1) * 6 + l * 3 + (w + 1);
                        tile.offset = new int[]{side == 4 ? l - 1 : (side == 5 ? 1 - l : (side == 2 ? -ww : ww)), h + 1, side == 2 ? l - 1 : (side == 3 ? 1 - l : (side == 5 ? -ww : ww))};
                    }
                }
            }
        }
        return b;
    }

    boolean structureCheck(World world, int startX, int startY, int startZ, int side, boolean mirror) {
        for (int h = -1; h <= 0; ++h) {
            for (int l = 0; l < 2; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    int fExpected;
                    int zz;
                    int yy;
                    int ww;
                    if (structure[h + 1][1 - l][w + 1] == null) continue;
                    int n = ww = mirror ? -w : w;
                    int xx = startX + (side == 4 ? l : (side == 5 ? -l : (side == 2 ? -ww : ww)));
                    if (world.func_147437_c(xx, yy = startY + h, zz = startZ + (side == 2 ? l : (side == 3 ? -l : (side == 5 ? -ww : ww))))) {
                        return false;
                    }
                    ItemStack checkStack = new ItemStack(world.func_147439_a(xx, yy, zz), 1, world.func_72805_g(xx, yy, zz));
                    if (!OreDictionary.itemMatches((ItemStack)structure[h + 1][1 - l][w + 1], (ItemStack)checkStack, (boolean)true)) {
                        return false;
                    }
                    TileEntity tile = world.func_147438_o(xx, yy, zz);
                    if (!(tile instanceof TileEntityConveyorBelt)) continue;
                    int f = ((TileEntityConveyorBelt)tile).facing;
                    int n2 = l == 1 ? (w == -1 ? ForgeDirection.OPPOSITES[side] : side) : (w < 1 ? ForgeDirection.ROTATION_MATRIX[mirror ? 0 : 1][side] : (fExpected = side));
                    if (f == fExpected) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ItemStack[] getTotalMaterials() {
        return new ItemStack[]{new ItemStack((Block)IEContent.blockMetalDecoration, 5, 1), new ItemStack((Block)IEContent.blockMetalDecoration, 2, 7), new ItemStack((Block)IEContent.blockMetalDevice, 5, 11)};
    }

    static {
        MultiblockBottlingMachine.bottle.pos = 4;
        MultiblockBottlingMachine.bottle.formed = true;
        for (int h = 0; h < 2; ++h) {
            for (int l = 0; l < 2; ++l) {
                for (int w = 0; w < 3; ++w) {
                    MultiblockBottlingMachine.structure[h][l][w] = l == 0 && w == 1 ? new ItemStack((Block)IEContent.blockMetalDecoration, 1, 7) : (h == 0 ? new ItemStack((Block)IEContent.blockMetalDecoration, 1, 1) : new ItemStack((Block)IEContent.blockMetalDevice, 1, 11));
                }
            }
        }
    }
}

