/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world;

import ftb.lib.PrivacyLevel;
import latmod.lib.Bits;
import latmod.lib.ByteIOStream;
import net.minecraft.nbt.NBTTagCompound;

public class PersonalSettings {
    public static final byte CHAT_LINKS = 0;
    public static final byte EXPLOSIONS = 1;
    public static final byte FAKE_PLAYERS = 2;
    public byte flags = 0;
    public PrivacyLevel blocks = PrivacyLevel.FRIENDS;

    public PersonalSettings() {
        this.setDefaultFlags();
    }

    private void setDefaultFlags() {
        this.set((byte)0, true);
        this.set((byte)1, true);
        this.set((byte)2, true);
    }

    public boolean set(byte flag, boolean v) {
        if (this.get(flag) != v) {
            this.flags = Bits.setBit((byte)this.flags, (byte)flag, (boolean)v);
            return true;
        }
        return false;
    }

    public boolean get(byte flag) {
        return Bits.getBit((byte)this.flags, (byte)flag);
    }

    public void readFromServer(NBTTagCompound tag) {
        if (!tag.func_74764_b("Flags")) {
            this.flags = 0;
            this.setDefaultFlags();
        } else {
            this.flags = tag.func_74771_c("Flags");
        }
        this.blocks = tag.func_74764_b("Blocks") ? (this.blocks = PrivacyLevel.VALUES_3[tag.func_74771_c("Blocks")]) : PrivacyLevel.FRIENDS;
    }

    public void writeToServer(NBTTagCompound tag) {
        tag.func_74774_a("Flags", this.flags);
        tag.func_74774_a("Blocks", (byte)this.blocks.ID);
    }

    public void readFromNet(ByteIOStream io) {
        this.flags = io.readByte();
        this.blocks = PrivacyLevel.VALUES_3[io.readUnsignedByte()];
    }

    public void writeToNet(ByteIOStream io) {
        io.writeByte((int)this.flags);
        io.writeByte(this.blocks.ID);
    }
}

