/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IRender;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.Validator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.genetics.api.IItemChargable;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.ModuleMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class Polymeriser {
    public static final int tankBacteria = 0;
    public static final int tankDNA = 1;
    public static final int slotSerum = 0;
    public static final int slotGold = 1;
    public static final int[] slotSerumReserve = new int[]{2, 3, 4, 5};
    public static final int[] slotSerumFinished = new int[]{6, 7, 8, 9};

    public static class ComponentPolymeriserFX
    extends MachineComponent
    implements IRender.RandomDisplayTick,
    IRender.DisplayTick {
        public ComponentPolymeriserFX(IMachine machine) {
            super(machine);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onRandomDisplayTick(World world, int x, int y, int z, Random rand) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onDisplayTick(World world, int x, int y, int z, Random rand) {
            int tick = (int)(world.func_82737_E() % 8L);
            if ((tick == 0 || tick == 3) && this.getUtil().getProcess().isInProgress()) {
                BinnieCore.proxy.getMinecraftInstance().field_71452_i.func_78873_a(new EntityFX(world, (double)x + 0.5, (double)y + 1.8, (double)z + 0.5, 0.0, 0.0, 0.0){
                    double axisX;
                    double axisZ;
                    double angle;
                    {
                        this.axisX = 0.0;
                        this.axisZ = 0.0;
                        this.angle = 0.0;
                        this.field_70159_w = 0.0;
                        this.field_70179_y = 0.0;
                        this.field_70181_x = -0.006;
                        this.field_70547_e = 140;
                        this.axisX = this.field_70165_t;
                        this.axisZ = this.field_70161_v;
                        this.field_70545_g = 0.0f;
                        this.angle = 0.7 + (double)((int)(this.field_70170_p.func_82737_E() % 2L)) * 3.1415;
                        this.field_70145_X = true;
                        this.func_70538_b(0.8f, 0.0f, 1.0f);
                    }

                    public void func_70071_h_() {
                        super.func_70071_h_();
                        this.angle += 0.1;
                        this.field_70181_x = -0.006;
                        double dist = 0.2;
                        if (this.field_70546_d > 60) {
                            dist = this.field_70546_d > 120 ? 0.1 : 0.2 - 0.1 * (double)(((float)this.field_70546_d - 60.0f) / 60.0f);
                        }
                        this.func_70107_b(this.axisX + dist * Math.sin(this.angle), this.field_70163_u, this.axisZ + dist * Math.cos(this.angle));
                        if (this.field_70546_d <= 40) {
                            this.func_82338_g((float)this.field_70546_d / 40.0f);
                        }
                        if (this.field_70546_d > 80) {
                            this.func_70538_b(this.field_70552_h + (0.0f - this.field_70552_h) / 10.0f, this.field_70553_i + (1.0f - this.field_70553_i) / 10.0f, this.field_70551_j + (1.0f - this.field_70551_j) / 10.0f);
                        }
                    }

                    public int func_70537_b() {
                        return 0;
                    }
                });
            }
        }
    }

    public static class SlotValidatorUnfilledSerum
    extends SlotValidator {
        public SlotValidatorUnfilledSerum() {
            super(ModuleMachine.IconSerum);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return itemStack.func_77973_b() instanceof IItemChargable;
        }

        @Override
        public String getTooltip() {
            return "Unfilled Serum";
        }
    }

    public static class ComponentPolymeriserLogic
    extends ComponentProcessSetCost
    implements IProcess {
        private static float chargePerProcess = 0.4f;
        private float dnaDrain = 0.0f;
        private float bacteriaDrain = 0.0f;

        public ComponentPolymeriserLogic(Machine machine) {
            super(machine, 96000, 2400);
        }

        private float getCatalyst() {
            return this.getUtil().getSlotCharge(1) > 0.0f ? 0.2f : 1.0f;
        }

        @Override
        public int getProcessLength() {
            return (int)((float)(super.getProcessLength() * this.getNumberOfGenes()) * this.getCatalyst());
        }

        @Override
        public int getProcessEnergy() {
            return (int)((float)(super.getProcessEnergy() * this.getNumberOfGenes()) * this.getCatalyst());
        }

        private float getDNAPerProcess() {
            return this.getNumberOfGenes() * 50;
        }

        @Override
        public void onTickTask() {
            super.onTickTask();
            this.getUtil().useCharge(1, chargePerProcess * this.getProgressPerTick() / 100.0f);
            this.dnaDrain += this.getDNAPerProcess() * this.getProgressPerTick() / 100.0f;
            this.bacteriaDrain += 0.2f * this.getDNAPerProcess() * this.getProgressPerTick() / 100.0f;
            if (this.dnaDrain >= 1.0f) {
                this.getUtil().drainTank(1, 1);
                this.dnaDrain -= 1.0f;
            }
            if (this.bacteriaDrain >= 1.0f) {
                this.getUtil().drainTank(0, 1);
                this.bacteriaDrain -= 1.0f;
            }
        }

        private int getNumberOfGenes() {
            ItemStack serum = this.getUtil().getStack(0);
            if (serum == null) {
                return 1;
            }
            return Engineering.getGenes(serum).length;
        }

        @Override
        public String getTooltip() {
            int n = this.getNumberOfGenes();
            return "Replicating " + n + " genes" + (n > 1 ? "s" : "");
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isSlotEmpty(0)) {
                return new ErrorState.NoItem("No item to replicate", 0);
            }
            if (!this.getUtil().getStack(0).func_77951_h()) {
                return new ErrorState.InvalidItem("Item filled", 0);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (this.getUtil().getFluid(0) == null) {
                return new ErrorState.InsufficientLiquid("Insufficient Bacteria", 0);
            }
            if (this.getUtil().getFluid(1) == null) {
                return new ErrorState.InsufficientLiquid("Insufficient DNA", 1);
            }
            return super.canProgress();
        }

        @Override
        protected void onFinishTask() {
            super.onFinishTask();
            this.getUtil().damageItem(0, -1);
        }
    }

    public static class PackagePolymeriser
    extends GeneticMachine.PackageGeneticBase
    implements IMachineInformation {
        public PackagePolymeriser() {
            super("polymeriser", GeneticsTexture.Polymeriser, 58819, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentGeneticGUI(machine, GeneticsGUI.Replicator);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(1, "catalyst");
            inventory.getSlot(1).setValidator((Validator)new SlotValidator.Item(new ItemStack(Items.field_151074_bl, 1), ModuleMachine.IconNugget));
            inventory.getSlot(1).forbidExtraction();
            inventory.addSlot(0, "process");
            inventory.getSlot(0).setValidator((Validator)new SlotValidatorUnfilledSerum());
            inventory.getSlot(0).forbidInteraction();
            inventory.getSlot(0).setReadOnly();
            for (InventorySlot slot : inventory.addSlotArray(slotSerumReserve, "input")) {
                slot.setValidator((Validator)new SlotValidatorUnfilledSerum());
                slot.forbidExtraction();
            }
            for (InventorySlot slot : inventory.addSlotArray(slotSerumFinished, "output")) {
                slot.setReadOnly();
            }
            ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
            transfer.addRestock(slotSerumReserve, 0, 1);
            transfer.addStorage(0, slotSerumFinished, new ComponentInventoryTransfer.Condition(){

                @Override
                public boolean fufilled(ItemStack stack) {
                    return !stack.func_77951_h();
                }
            });
            ComponentTankContainer tank = new ComponentTankContainer(machine);
            tank.addTank(0, "input", 1000);
            tank.getTankSlot(0).setValidator((Validator)new Validator<FluidStack>(){

                @Override
                public boolean isValid(FluidStack itemStack) {
                    return GeneticLiquid.BacteriaPoly.get(1).isFluidEqual(itemStack);
                }

                @Override
                public String getTooltip() {
                    return "Polymerising Bacteria";
                }
            });
            tank.addTank(1, "input", 1000);
            tank.getTankSlot(1).setValidator((Validator)new Validator<FluidStack>(){

                @Override
                public boolean isValid(FluidStack itemStack) {
                    return GeneticLiquid.RawDNA.get(1).isFluidEqual(itemStack);
                }

                @Override
                public String getTooltip() {
                    return "Raw DNA";
                }
            });
            new ComponentChargedSlots(machine).addCharge(1);
            new ComponentPowerReceptor(machine, 8000);
            new ComponentPolymeriserLogic(machine);
            new ComponentPolymeriserFX(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

