/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.Binnie;
import binnie.core.liquid.IFluidType;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.inventory.Validator;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extratrees.alcohol.Alcohol;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.machines.ExtraTreeMachine;
import cpw.mods.fml.relauncher.Side;
import forestry.api.core.INBTTagable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class Brewery {
    public static int[] slotRecipeGrains = new int[]{0, 1, 2};
    public static int slotRecipeInput = 3;
    public static int slotRecipeYeast = 4;
    public static int[] slotInventory = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13};
    public static int tankInput = 0;
    public static int tankOutput = 1;
    private static List<IBreweryRecipe> recipes = new ArrayList<IBreweryRecipe>();

    public static boolean isValidGrain(ItemStack itemstack) {
        for (IBreweryRecipe recipe : recipes) {
            for (ItemStack ingredient : recipe.getGrains()) {
                if (!ingredient.func_77969_a(itemstack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidYeast(ItemStack itemstack) {
        for (IBreweryRecipe recipe : recipes) {
            for (ItemStack ingredient : recipe.getYeasts()) {
                if (!ingredient.func_77969_a(itemstack)) continue;
                return true;
            }
        }
        return false;
    }

    public static FluidStack getOutput(FluidStack stack) {
        BreweryCrafting crafting = new BreweryCrafting(stack, null, null, null);
        for (IBreweryRecipe recipe : recipes) {
            if (recipe.getOutput(crafting) == null) continue;
            return recipe.getOutput(crafting);
        }
        return null;
    }

    public static FluidStack getOutput(BreweryCrafting crafting) {
        if (crafting.currentInput == null) {
            return null;
        }
        if (crafting.yeast == null) {
            return null;
        }
        for (IBreweryRecipe recipe : recipes) {
            if (recipe.getOutput(crafting) == null) continue;
            return recipe.getOutput(crafting);
        }
        return null;
    }

    public static boolean isValidIngredient(ItemStack itemstack) {
        for (IBreweryRecipe recipe : recipes) {
            for (ItemStack ingr : recipe.getIngredient()) {
                if (!ingr.func_77969_a(itemstack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidInputLiquid(FluidStack fluid) {
        for (IBreweryRecipe recipe : recipes) {
            for (FluidStack ingr : recipe.getInput()) {
                if (!ingr.isFluidEqual(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidOutputLiquid(FluidStack fluid) {
        for (IBreweryRecipe recipe : recipes) {
            for (FluidStack ingr : recipe.getOutput()) {
                if (!ingr.isFluidEqual(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addRecipe(FluidStack input, FluidStack output) {
        recipes.add(new BreweryRecipe(input, output));
    }

    public static void addBeerAndMashRecipes() {
        recipes.add(new BeerRecipe());
    }

    public static class BeerRecipe
    implements IBreweryRecipe {
        Map<ItemStack, String> grainCrops = new HashMap<ItemStack, String>();
        List<FluidStack> outputs = new ArrayList<FluidStack>();
        static String barley = "seedBarley";
        static String wheat = "seedWheat";
        static String rye = "seedRye";
        static String corn = "seedCorn";
        static String roasted = "seedRoasted";
        String[] grains;
        FluidStack water;
        ItemStack hops;

        public BeerRecipe() {
            for (String grainType : this.grains = new String[]{barley, wheat, rye, corn, roasted}) {
                for (ItemStack stack : OreDictionary.getOres((String)grainType)) {
                    this.grainCrops.put(stack, grainType);
                }
            }
            this.water = Binnie.Liquid.getLiquidStack("water", 5);
            this.hops = (ItemStack)OreDictionary.getOres((String)"cropHops").get(0);
            this.add(Alcohol.Ale);
            this.add(Alcohol.Lager);
            this.add(Alcohol.Stout);
            this.add(Alcohol.CornBeer);
            this.add(Alcohol.RyeBeer);
            this.add(Alcohol.WheatBeer);
            this.add(Alcohol.Barley);
            this.add(Alcohol.Corn);
            this.add(Alcohol.Rye);
            this.add(Alcohol.Wheat);
        }

        private void add(IFluidType fluid) {
            this.outputs.add(fluid.get(1));
        }

        @Override
        public FluidStack getOutput(BreweryCrafting crafting) {
            if (!crafting.currentInput.isFluidEqual(this.water)) {
                return null;
            }
            int roasted = 0;
            int barley = 0;
            int wheat = 0;
            int rye = 0;
            int corn = 0;
            for (ItemStack stack : crafting.inputs) {
                if (stack == null) {
                    return null;
                }
                String name = "";
                for (Map.Entry<ItemStack, String> entry : this.grainCrops.entrySet()) {
                    if (!entry.getKey().func_77969_a(stack)) continue;
                    name = entry.getValue();
                    break;
                }
                if (name.isEmpty()) {
                    return null;
                }
                if (name.equals(BeerRecipe.roasted)) {
                    ++roasted;
                }
                if (name.equals(BeerRecipe.barley)) {
                    ++barley;
                }
                if (name.equals(BeerRecipe.wheat)) {
                    ++wheat;
                }
                if (name.equals(BeerRecipe.rye)) {
                    ++rye;
                }
                if (!name.equals(BeerRecipe.corn)) continue;
                ++corn;
            }
            boolean isBeer = crafting.ingr != null;
            boolean isLager = crafting.yeast.func_77969_a(ExtraTreeItems.LagerYeast.get(1));
            if (roasted >= 2 && isBeer) {
                return Alcohol.Stout.get(5);
            }
            if (wheat >= 2) {
                return isBeer ? Alcohol.WheatBeer.get(5) : Alcohol.Wheat.get(5);
            }
            if (rye >= 2) {
                return isBeer ? Alcohol.RyeBeer.get(5) : Alcohol.Rye.get(5);
            }
            if (corn >= 2) {
                return isBeer ? Alcohol.CornBeer.get(5) : Alcohol.Corn.get(5);
            }
            return isBeer ? (isLager ? Alcohol.Lager.get(5) : Alcohol.Ale.get(5)) : Alcohol.Barley.get(5);
        }

        @Override
        public FluidStack[] getInput() {
            return new FluidStack[]{this.water};
        }

        @Override
        public FluidStack[] getOutput() {
            return this.outputs.toArray(new FluidStack[0]);
        }

        @Override
        public ItemStack[] getGrains() {
            return this.grainCrops.keySet().toArray(new ItemStack[0]);
        }

        @Override
        public ItemStack[] getIngredient() {
            return new ItemStack[]{this.hops};
        }

        @Override
        public ItemStack[] getYeasts() {
            return new ItemStack[]{ExtraTreeItems.Yeast.get(1), ExtraTreeItems.LagerYeast.get(1)};
        }
    }

    public static class BreweryRecipe
    implements IBreweryRecipe {
        FluidStack input;
        ItemStack specificYeast;
        FluidStack output;

        public BreweryRecipe(FluidStack input, FluidStack output) {
            this(input, null, output);
        }

        public BreweryRecipe(FluidStack input, ItemStack specificYeast, FluidStack output) {
            this.input = input;
            this.specificYeast = specificYeast;
            this.output = output;
        }

        @Override
        public FluidStack getOutput(BreweryCrafting crafting) {
            if (this.specificYeast != null && !this.specificYeast.func_77969_a(crafting.yeast)) {
                return null;
            }
            if (this.input.isFluidEqual(crafting.currentInput)) {
                return this.output;
            }
            return null;
        }

        @Override
        public FluidStack[] getInput() {
            return new FluidStack[]{this.input};
        }

        @Override
        public FluidStack[] getOutput() {
            return new FluidStack[0];
        }

        @Override
        public ItemStack[] getGrains() {
            return new ItemStack[0];
        }

        @Override
        public ItemStack[] getIngredient() {
            return new ItemStack[0];
        }

        @Override
        public ItemStack[] getYeasts() {
            return new ItemStack[]{ExtraTreeItems.Yeast.get(1)};
        }
    }

    private static interface IBreweryRecipe {
        public FluidStack getOutput(BreweryCrafting var1);

        public FluidStack[] getInput();

        public FluidStack[] getOutput();

        public ItemStack[] getGrains();

        public ItemStack[] getIngredient();

        public ItemStack[] getYeasts();
    }

    public static class TankValidatorFermentOutput
    extends TankValidator {
        @Override
        public boolean isValid(FluidStack itemStack) {
            return Brewery.isValidOutputLiquid(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Fermented Liquids";
        }
    }

    public static class TankValidatorFermentInput
    extends TankValidator {
        @Override
        public boolean isValid(FluidStack itemStack) {
            return Brewery.isValidInputLiquid(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Fermentable Liquids";
        }
    }

    public static class SlotValidatorYeast
    extends SlotValidator {
        public SlotValidatorYeast() {
            super(SlotValidator.IconBlock);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return Brewery.isValidYeast(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Yeast";
        }
    }

    public static class SlotValidatorBreweryIngredient
    extends SlotValidator {
        public SlotValidatorBreweryIngredient() {
            super(SlotValidator.IconBlock);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return Brewery.isValidIngredient(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Brewing Ingredient";
        }
    }

    public static class SlotValidatorBreweryGrain
    extends SlotValidator {
        public SlotValidatorBreweryGrain() {
            super(SlotValidator.IconBlock);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return Brewery.isValidGrain(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Brewing Grains";
        }
    }

    public static class ComponentBreweryLogic
    extends ComponentProcessSetCost
    implements IProcess,
    INetwork.GuiNBT {
        public BreweryCrafting currentCrafting = null;

        public ComponentBreweryLogic(Machine machine) {
            super(machine, 16000, 800);
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isTankEmpty(tankInput) && this.currentCrafting == null) {
                return new ErrorState.InsufficientLiquid("No Input Liquid", tankInput);
            }
            if (Brewery.getOutput(this.getInputCrafting()) == null && this.currentCrafting == null) {
                return new ErrorState("No Recipe", "Brewing cannot occur with these ingredients");
            }
            if (!this.getUtil().hasIngredients(new int[]{0, 1, 2, 3, 4}, slotInventory) && this.currentCrafting == null) {
                return new ErrorState("Insufficient Ingredients", "Not enough ingredients for Brewing");
            }
            return super.canWork();
        }

        private BreweryCrafting getInputCrafting() {
            return new BreweryCrafting(this.getUtil().getFluid(tankInput), this.getUtil().getStack(slotRecipeInput), this.getUtil().getStacks(slotRecipeGrains), this.getUtil().getStack(slotRecipeYeast));
        }

        @Override
        public ErrorState canProgress() {
            if (this.currentCrafting == null) {
                return new ErrorState("Brewery Empty", "No liquid in Brewery");
            }
            if (!this.getUtil().spaceInTank(tankOutput, 1000)) {
                return new ErrorState.TankSpace("No Space for Fermented Liquid", tankOutput);
            }
            if (this.getUtil().getFluid(tankOutput) != null && !this.getUtil().getFluid(tankOutput).isFluidEqual(Brewery.getOutput(this.currentCrafting))) {
                return new ErrorState.TankSpace("Different fluid in tank", tankOutput);
            }
            return super.canProgress();
        }

        @Override
        protected void onFinishTask() {
            FluidStack output = Brewery.getOutput(this.currentCrafting).copy();
            output.amount = 1000;
            this.getUtil().fillTank(tankOutput, output);
        }

        @Override
        public void onUpdate() {
            super.onUpdate();
            if (this.canWork() == null && this.currentCrafting == null && this.getUtil().getTank(tankInput).getFluidAmount() >= 1000) {
                FluidStack stack = this.getUtil().drainTank(tankInput, 1000);
                this.currentCrafting = this.getInputCrafting();
                this.currentCrafting.currentInput = stack;
            }
        }

        @Override
        public void sendGuiNBT(Map<String, NBTTagCompound> data) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.currentCrafting == null) {
                nbt.func_74757_a("null", true);
            } else {
                this.currentCrafting.writeToNBT(nbt);
            }
            data.put("brewery-recipe", nbt);
        }

        @Override
        public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound nbt) {
            if (name.equals("brewery-recipe")) {
                this.currentCrafting = nbt.func_74767_n("null") ? null : new BreweryCrafting(nbt);
            }
        }

        @Override
        public String getTooltip() {
            if (this.currentCrafting == null) {
                return "Empty";
            }
            return "Creating " + Brewery.getOutput(this.currentCrafting).getFluid().getLocalizedName();
        }
    }

    public static class BreweryCrafting
    implements INBTTagable {
        public FluidStack currentInput;
        public ItemStack[] inputs;
        public ItemStack ingr;
        public ItemStack yeast;

        public BreweryCrafting(FluidStack currentInput, ItemStack ingr, ItemStack[] inputs, ItemStack yeast) {
            this.currentInput = currentInput;
            this.inputs = inputs == null ? new ItemStack[3] : inputs;
            this.ingr = ingr;
            this.yeast = yeast;
        }

        public BreweryCrafting(NBTTagCompound nbt) {
            this.readFromNBT(nbt);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.currentInput = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid"));
            this.ingr = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("ingr"));
            this.inputs = new ItemStack[3];
            this.inputs[0] = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("in1"));
            this.inputs[1] = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("in2"));
            this.inputs[2] = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("in3"));
            this.yeast = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("yeast"));
        }

        public void writeToNBT(NBTTagCompound nbt) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            this.currentInput.writeToNBT(fluidTag);
            nbt.func_74782_a("fluid", (NBTBase)fluidTag);
            nbt.func_74782_a("ingr", (NBTBase)this.getNBT(this.ingr));
            nbt.func_74782_a("in1", (NBTBase)this.getNBT(this.inputs[0]));
            nbt.func_74782_a("in2", (NBTBase)this.getNBT(this.inputs[1]));
            nbt.func_74782_a("in3", (NBTBase)this.getNBT(this.inputs[2]));
            nbt.func_74782_a("yeast", (NBTBase)this.getNBT(this.yeast));
        }

        private NBTTagCompound getNBT(ItemStack ingr) {
            if (ingr == null) {
                return new NBTTagCompound();
            }
            NBTTagCompound nbt = new NBTTagCompound();
            ingr.func_77955_b(nbt);
            return nbt;
        }
    }

    public static class PackageBrewery
    extends ExtraTreeMachine.PackageExtraTreeMachine
    implements IMachineInformation {
        public PackageBrewery() {
            super("brewery", ExtraTreeTexture.breweryTexture, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.Brewery);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlotArray(slotRecipeGrains, "grain");
            for (InventorySlot slot : inventory.getSlots(slotRecipeGrains)) {
                slot.setValidator((Validator)new SlotValidatorBreweryGrain());
                slot.setType(InventorySlot.Type.Recipe);
            }
            inventory.addSlotArray(slotInventory, "inventory");
            for (InventorySlot slot : inventory.getSlots(slotInventory)) {
                slot.forbidExtraction();
            }
            inventory.addSlot(slotRecipeYeast, "yeast");
            inventory.getSlot(slotRecipeYeast).setValidator((Validator)new SlotValidatorYeast());
            inventory.getSlot(slotRecipeYeast).setType(InventorySlot.Type.Recipe);
            inventory.addSlot(slotRecipeInput, "ingredient");
            inventory.getSlot(slotRecipeInput).setValidator((Validator)new SlotValidatorBreweryIngredient());
            inventory.getSlot(slotRecipeInput).setType(InventorySlot.Type.Recipe);
            ComponentTankContainer tanks = new ComponentTankContainer(machine);
            tanks.addTank(tankInput, "input", 5000);
            tanks.getTankSlot(tankInput).setValidator((Validator)new TankValidatorFermentInput());
            tanks.getTankSlot(tankInput).setOutputSides((EnumSet)MachineSide.TopAndBottom);
            tanks.addTank(tankOutput, "output", 5000);
            tanks.getTankSlot(tankOutput).setValidator((Validator)new TankValidatorFermentOutput());
            tanks.getTankSlot(tankOutput).forbidInsertion();
            tanks.getTankSlot(tankOutput).setOutputSides((EnumSet)MachineSide.Sides);
            new ComponentPowerReceptor(machine);
            new ComponentBreweryLogic(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

