/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block.decor;

import binnie.Binnie;
import binnie.core.Mods;
import binnie.core.block.BlockMetadata;
import binnie.core.block.IBlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.block.WoodManager;
import binnie.extratrees.block.decor.FenceDescription;
import binnie.extratrees.block.decor.IBlockFence;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFence
extends net.minecraft.block.BlockFence
implements IBlockMetadata,
IBlockFence {
    public BlockFence() {
        super("", Material.field_151575_d);
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149663_c("fence");
        this.func_149752_b(5.0f);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149766_f);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (PlankType.ExtraTreePlanks type : PlankType.ExtraTreePlanks.values()) {
            itemList.add(type.getFence());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntityMetadata tile = TileEntityMetadata.getTile(world, x, y, z);
        if (tile != null) {
            return this.func_149691_a(side, tile.getTileMetadata());
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public FenceDescription getDescription(int meta) {
        return WoodManager.getFenceDescription(meta);
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.getDescription(meta).getPlankType().getIcon();
    }

    public int func_149645_b() {
        return ExtraTrees.fenceID;
    }

    @Override
    public void dropAsStack(World world, int x, int y, int z, ItemStack drop) {
        this.func_149642_a(world, x, y, z, drop);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int blockMeta, int fortune) {
        return BlockMetadata.getBlockDropped(this, world, x, y, z, blockMeta);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return BlockMetadata.breakBlock(this, player, world, x, y, z);
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileEntityMetadata();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean func_149696_a(World par1World, int par2, int par3, int par4, int par5, int par6) {
        super.func_149696_a(par1World, par2, par3, par4, par5, par6);
        TileEntity tileentity = par1World.func_147438_o(par2, par3, par4);
        return tileentity != null ? tileentity.func_145842_c(par5, par6) : false;
    }

    @Override
    public int getPlacedMeta(ItemStack stack, World world, int x, int y, int z, ForgeDirection clickedBlock) {
        return TileEntityMetadata.getItemDamage(stack);
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        return tileMeta;
    }

    @Override
    public String getBlockName(ItemStack par1ItemStack) {
        int meta = TileEntityMetadata.getItemDamage(par1ItemStack);
        return Binnie.Language.localise(ExtraTrees.instance, "block.woodfence.name", this.getDescription(meta).getPlankType().getName());
    }

    @Override
    public void getBlockTooltip(ItemStack par1ItemStack, List par3List) {
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean func_149826_e(IBlockAccess world, int x, int y, int z) {
        if (!this.isFence(world, x, y, z)) {
            Block block = world.func_147439_a(x, y, z);
            return block != null && block.func_149688_o().func_76218_k() && block.func_149686_d();
        }
        return true;
    }

    public boolean isFence(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return BlockFence.canConnect(block);
    }

    public static boolean canConnect(Block block) {
        return block == ((ItemBlock)Mods.Forestry.item((String)"fences")).field_150939_a || block == ((ItemBlock)Mods.Forestry.item((String)"fences2")).field_150939_a || block == Blocks.field_150422_aJ || block == Blocks.field_150396_be || block == Blocks.field_150386_bk || block instanceof IBlockFence || block == ExtraTrees.blockGate;
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
        par1World.func_147475_p(par2, par3, par4);
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 20;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return BlockMetadata.getPickBlock(world, x, y, z);
    }
}

