/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.Binnie;
import binnie.core.liquid.FluidContainer;
import binnie.core.liquid.IFluidType;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.ICocktailLiquid;
import binnie.extratrees.alcohol.Juice;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidStack;

public enum Alcohol implements IFluidType,
ICocktailLiquid
{
    Apple("ciderApple", 16432700, 0.3, 0.05),
    Apricot("wineApricot", 15781686, 0.3, 0.1),
    Banana("wineBanana", 14993485, 0.3, 0.1),
    Cherry("wineCherry", 11207702, 0.3, 0.1),
    Elderberry("wineElderberry", 9764865, 0.3, 0.1),
    Peach("ciderPeach", 15361563, 0.3, 0.05),
    Pear("ciderPear", 15061095, 0.3, 0.05),
    Plum("winePlum", 12063752, 0.3, 0.1),
    Carrot("wineCarrot", 16219394, 0.3, 0.1),
    WhiteWine("wineWhite", 15587989, 0.1, 0.1),
    RedWine("wineRed", 7670539, 0.2, 0.1),
    SparklingWine("wineSparkling", 16709566, 0.1, 0.1),
    Agave("wineAgave", 13938276, 0.2, 0.1),
    Potato("fermentedPotatoes", 12028240, 0.8, 0.1),
    Citrus("wineCitrus", 0xFFFF00, 0.2, 0.1),
    Cranberry("wineCranberry", 11599874, 0.2, 0.1),
    Pineapple("winePineapple", 14724150, 0.2, 0.1),
    Tomato("wineTomato", 12458521, 0.2, 0.1),
    Fruit("juice", 16432700, 0.2, 0.1),
    Ale("beerAle", 12991009, 0.7, 0.05),
    Lager("beerLager", 15301637, 0.7, 0.05),
    WheatBeer("beerWheat", 14380552, 0.7, 0.05),
    RyeBeer("beerRye", 10836007, 0.7, 0.05),
    CornBeer("beerCorn", 13411364, 0.7, 0.05),
    Stout("beerStout", 5843201, 0.8, 0.05),
    Barley("mashGrain", 12991009, 0.9, 0.05),
    Wheat("mashWheat", 12991009, 0.9, 0.05),
    Rye("mashRye", 10836007, 0.9, 0.05),
    Corn("mashCorn", 13411364, 0.9, 0.05);

    List<String> fermentationLiquid = new ArrayList<String>();
    String fermentationSolid = "";
    String ident;
    IIcon icon;
    int colour;
    float transparency;
    float abv;

    private void setFementation(Juice juice) {
        this.fermentationLiquid.add(juice.getIdentifier());
    }

    private void setFementation(String oreDict) {
        this.fermentationSolid = oreDict;
    }

    private Alcohol(String ident, int colour, double transparency, double abv) {
        this.ident = ident;
        this.colour = colour;
        this.transparency = (float)transparency;
        this.abv = (float)abv;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public void registerIcon(IIconRegister register) {
        this.icon = ExtraTrees.proxy.getIcon(register, "liquids/liquid");
    }

    @Override
    public String getName() {
        return ExtraTrees.proxy.localise("fluid.alcohol." + this.name().toLowerCase());
    }

    @Override
    public String getIdentifier() {
        return "binnie." + this.ident;
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public FluidStack get(int amount) {
        return Binnie.Liquid.getLiquidStack(this.getIdentifier(), amount);
    }

    @Override
    public int getTransparency() {
        return (int)(Math.min(1.0, (double)this.transparency + 0.3) * 255.0);
    }

    @Override
    public String getTooltip(int ratio) {
        return ratio + " Part" + (ratio > 1 ? "s " : " ") + this.getName();
    }

    @Override
    public boolean canPlaceIn(FluidContainer container) {
        return true;
    }

    @Override
    public boolean showInCreative(FluidContainer container) {
        return container == FluidContainer.Glass;
    }

    @Override
    public int getContainerColour() {
        return this.getColour();
    }

    @Override
    public float getABV() {
        return this.abv;
    }

    static {
        Apple.setFementation(Juice.Apple);
        Apricot.setFementation(Juice.Apricot);
        Banana.setFementation(Juice.Banana);
        Cherry.setFementation(Juice.Cherry);
        Elderberry.setFementation(Juice.Elderberry);
        Peach.setFementation(Juice.Peach);
        Pear.setFementation(Juice.Pear);
        Plum.setFementation(Juice.Plum);
        Carrot.setFementation(Juice.Carrot);
        WhiteWine.setFementation(Juice.WhiteGrape);
        RedWine.setFementation(Juice.RedGrape);
        Citrus.setFementation(Juice.Lemon);
        Citrus.setFementation(Juice.Lime);
        Citrus.setFementation(Juice.Orange);
        Citrus.setFementation(Juice.Grapefruit);
        Tomato.setFementation(Juice.Tomato);
        Cranberry.setFementation(Juice.Cranberry);
        Pineapple.setFementation(Juice.Pineapple);
        Potato.setFementation("cropPotato");
    }
}

