/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network.packet;

import binnie.core.network.packet.IPacketLocation;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.network.packet.MessageNBT;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MessageTileNBT
extends MessageNBT
implements IPacketLocation {
    private int posX;
    private int posY;
    private int posZ;

    public MessageTileNBT(MessageBinnie message) {
        super(message);
    }

    public MessageTileNBT(int id, TileEntity tile, NBTTagCompound nbt) {
        super(id);
        this.posX = tile.field_145851_c;
        this.posY = tile.field_145848_d;
        this.posZ = tile.field_145849_e;
        this.nbt = nbt;
    }

    @Override
    public void writeData(ByteBuf data) throws IOException {
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
        super.writeData(data);
    }

    @Override
    public void readData(ByteBuf data) throws IOException {
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
        super.readData(data);
    }

    @Override
    public TileEntity getTarget(World world) {
        return world.func_147438_o(this.posX, this.posY, this.posZ);
    }

    @Override
    public int getX() {
        return this.posX;
    }

    @Override
    public int getY() {
        return this.posY;
    }

    @Override
    public int getZ() {
        return this.posZ;
    }

    @Override
    public NBTTagCompound getTagCompound() {
        return this.nbt;
    }

    @Override
    void setTagCompound(NBTTagCompound nbt) {
        this.nbt = nbt;
    }
}

