/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.mod.config;

import binnie.core.mod.config.BinnieConfiguration;
import binnie.core.mod.config.ConfigProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

abstract class PropertyBase<ValueType, AnnotationType extends Annotation> {
    Configuration file;
    Property property;
    ValueType defaultValue;
    private ConfigProperty configProperty;
    AnnotationType annotatedProperty;
    private List<String> comments = new ArrayList<String>();
    private Field field;

    protected PropertyBase(Field field, BinnieConfiguration file, ConfigProperty configProperty, AnnotationType annotedProperty) throws IllegalArgumentException, IllegalAccessException {
        this.field = field;
        this.file = file;
        this.configProperty = configProperty;
        this.annotatedProperty = annotedProperty;
        this.defaultValue = this.getDefaultValue(field);
        this.property = this.getProperty();
        for (String comment : configProperty.comment()) {
            this.addComment(comment);
        }
        this.addComments();
        this.property.comment = this.getComment();
        field.set(null, this.getConfigValue());
    }

    protected abstract Property getProperty();

    protected abstract ValueType getConfigValue();

    protected abstract void addComments();

    protected String getCategory() {
        return this.configProperty.category().equals("") ? this.annotatedProperty.annotationType().getAnnotation(ConfigProperty.Type.class).category() : this.configProperty.category();
    }

    protected String getKey() {
        return this.configProperty.key();
    }

    protected ValueType getDefaultValue(Field field) throws IllegalArgumentException, IllegalAccessException {
        return (ValueType)field.get(null);
    }

    protected void addComment(String comment) {
        this.comments.add(comment);
    }

    protected String getComment() {
        String comment = "";
        for (String com : this.comments) {
            comment = comment + com + " ";
        }
        return comment;
    }
}

