/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools;

import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.draconicevolution.client.render.IRenderTweak;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.MiningTool;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.ToolHandler;
import com.brandon3055.draconicevolution.common.items.weapons.IEnergyContainerWeaponItem;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class DraconicDistructionStaff
extends MiningTool
implements IInventoryTool,
IRenderTweak,
IEnergyContainerWeaponItem {
    public DraconicDistructionStaff() {
        super(ModItems.CHAOTIC);
        this.func_77655_b("draconicDistructionStaff");
        this.setHarvestLevel("pickaxe", 10);
        this.setHarvestLevel("shovel", 10);
        this.setHarvestLevel("axe", 10);
        this.setCapacity(BalanceConfigHandler.draconicToolsBaseStorage * 2 + BalanceConfigHandler.draconicWeaponsBaseStorage);
        this.setMaxExtract(BalanceConfigHandler.draconicToolsMaxTransfer * 2 + BalanceConfigHandler.draconicWeaponsMaxTransfer);
        this.setMaxReceive(BalanceConfigHandler.draconicToolsMaxTransfer * 2 + BalanceConfigHandler.draconicWeaponsMaxTransfer);
        this.energyPerOperation = BalanceConfigHandler.draconicToolsEnergyPerAction;
        ModItems.register(this);
    }

    @Override
    public float func_150893_a(ItemStack stack, Block block) {
        return this.getEfficiency(stack);
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        List<ItemConfigField> list = super.getFields(stack, slot);
        list.add(new ItemConfigField(2, slot, "ToolDigAOE").setMinMaxAndIncromente(0, IUpgradableItem.EnumUpgrade.DIG_AOE.getUpgradePoints(stack), 1).readFromItem(stack, 0).setModifier("AOE"));
        list.add(new ItemConfigField(2, slot, "ToolDigDepth").setMinMaxAndIncromente(1, IUpgradableItem.EnumUpgrade.DIG_DEPTH.getUpgradePoints(stack), 1).readFromItem(stack, 1));
        list.add(new ItemConfigField(2, slot, "WeaponAttackAOE").setMinMaxAndIncromente(0, IUpgradableItem.EnumUpgrade.ATTACK_AOE.getUpgradePoints(stack), 1).readFromItem(stack, 1).setModifier("AOE"));
        list.add(new ItemConfigField(6, slot, "ToolVoidJunk").readFromItem(stack, false));
        return list;
    }

    @Override
    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryOblit.txt");
    }

    @Override
    public int getInventorySlots() {
        return 9;
    }

    @Override
    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.digger || enchant.field_77351_y == EnumEnchantmentType.weapon;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        entity.field_70172_ad = 0;
        ToolHandler.damageEntityBasedOnHealth(entity, player, 0.3f);
        ToolHandler.AOEAttack(player, entity, stack, IConfigurableItem.ProfileHelper.getInteger(stack, "WeaponAttackAOE", 0));
        return true;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return super.func_77659_a(stack, world, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extended) {
        super.func_77624_a(stack, player, list, extended);
        list.add("");
        list.add(EnumChatFormatting.BLUE + "+" + ToolHandler.getBaseAttackDamage(stack) + " " + StatCollector.func_74838_a((String)"info.de.attackDamage.txt"));
        list.add(EnumChatFormatting.BLUE + "+30%" + " " + StatCollector.func_74838_a((String)"info.de.bonusHealthDamage.txt"));
    }

    @Override
    public void tweakRender(IItemRenderer.ItemRenderType type) {
        GL11.glTranslated((double)0.77, (double)0.19, (double)-0.15);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-35.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)6.0f, (float)6.0f, (float)6.0f);
            GL11.glRotatef((float)145.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.7, (double)0.0, (double)1.8);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)-34.5f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.1, (double)0.0, (double)-0.2);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslated((double)0.0, (double)0.4, (double)0.0);
        }
    }

    @Override
    public int getUpgradeCap(ItemStack itemstack) {
        return BalanceConfigHandler.draconicStaffMaxUpgrades;
    }

    @Override
    public int getMaxTier(ItemStack itemstack) {
        return 2;
    }

    @Override
    public int getMaxUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.RF_CAPACITY.index) {
            return BalanceConfigHandler.draconicStaffMaxCapacityUpgradePoints;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_AOE.index) {
            return 5;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_DEPTH.index) {
            return 11;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_AOE.index) {
            return 13;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_DAMAGE.index) {
            return 64;
        }
        return BalanceConfigHandler.draconicStaffMaxUpgradePoints;
    }

    @Override
    public int getBaseUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_AOE.index) {
            return 3;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_DEPTH.index) {
            return 7;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_AOE.index) {
            return 3;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_DAMAGE.index) {
            return 0;
        }
        return 0;
    }

    @Override
    public int getCapacity(ItemStack stack) {
        int points = IUpgradableItem.EnumUpgrade.RF_CAPACITY.getUpgradePoints(stack);
        return BalanceConfigHandler.draconicToolsBaseStorage * 2 + BalanceConfigHandler.draconicWeaponsBaseStorage + points * (BalanceConfigHandler.draconicToolsStoragePerUpgrade + BalanceConfigHandler.draconicWeaponsStoragePerUpgrade);
    }

    @Override
    public List<IUpgradableItem.EnumUpgrade> getUpgrades(ItemStack itemstack) {
        List<IUpgradableItem.EnumUpgrade> list = super.getUpgrades(itemstack);
        list.add(IUpgradableItem.EnumUpgrade.ATTACK_AOE);
        list.add(IUpgradableItem.EnumUpgrade.ATTACK_DAMAGE);
        list.remove((Object)IUpgradableItem.EnumUpgrade.DIG_SPEED);
        return list;
    }

    @Override
    public List<String> getUpgradeStats(ItemStack stack) {
        List<String> list = super.getUpgradeStats(stack);
        list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"info.de.attackDamage.txt") + ": " + InfoHelper.HITC() + ToolHandler.getBaseAttackDamage(stack));
        return list;
    }

    @Override
    public int getEnergyPerAttack() {
        return BalanceConfigHandler.draconicWeaponsEnergyPerAttack;
    }
}

