/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.mod;

import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.Waypoint;
import journeymap.client.model.mod.ModBlockDelegate;
import journeymap.client.waypoint.WaypointStore;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class Miscellaneous {

    public static class OpenBlocksGraveHandler
    implements ModBlockDelegate.IModBlockHandler {
        public static final GameRegistry.UniqueIdentifier UID = new GameRegistry.UniqueIdentifier("OpenBlocks:grave");
        private static final String TAG_PLAYERNAME = "PlayerName";
        private static final String TAG_PLAYERUUID = "PlayerUUID";

        @Override
        public boolean initialize(BlockMD blockMD) {
            if (blockMD.getUid().equals((Object)UID)) {
                blockMD.setModBlockHandler(this);
                return true;
            }
            return false;
        }

        @Override
        public BlockMD handleBlock(ChunkMD chunkMD, BlockMD blockMD, int localX, int y, int localZ) {
            int blockZ;
            int blockX = chunkMD.toWorldX(localX);
            TileEntity tileEntity = ForgeHelper.INSTANCE.getTileEntity(blockX, y, blockZ = chunkMD.toWorldZ(localZ));
            if (tileEntity != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tileEntity.func_145841_b(tag);
                String playerName = null;
                playerName = tag.func_82582_d() ? "?" : tag.func_74779_i(TAG_PLAYERNAME);
                if (playerName == null) {
                    playerName = "";
                }
                Waypoint waypoint = new Waypoint(playerName + " " + blockMD.getName(), blockX, y, blockZ, Color.red, Waypoint.Type.Death, chunkMD.getDimension());
                WaypointStore.instance().add(waypoint);
            }
            return blockMD;
        }
    }

    public static class CommonHandler
    implements ModBlockDelegate.IModBlockHandler {
        GameRegistry.UniqueIdentifier maricultureKelpId = new GameRegistry.UniqueIdentifier("Mariculture:kelp");
        GameRegistry.UniqueIdentifier thaumcraftLeavesId = new GameRegistry.UniqueIdentifier("Thaumcraft:blockMagicalLeaves");
        List<GameRegistry.UniqueIdentifier> torches = new ArrayList<GameRegistry.UniqueIdentifier>();

        public CommonHandler() {
            this.torches.add(new GameRegistry.UniqueIdentifier("TConstruct:decoration.stonetorch"));
            this.torches.add(new GameRegistry.UniqueIdentifier("ExtraUtilities:magnumTorch"));
            this.torches.add(new GameRegistry.UniqueIdentifier("appliedenergistics2:tile.BlockQuartzTorch"));
            for (int i = 1; i <= 10; ++i) {
                this.torches.add(new GameRegistry.UniqueIdentifier("chisel:torch" + i));
            }
        }

        @Override
        public boolean initialize(BlockMD blockMD) {
            GameRegistry.UniqueIdentifier uid = blockMD.getUid();
            if (this.torches.contains(uid)) {
                blockMD.addFlags(BlockMD.Flag.HasAir, BlockMD.Flag.NoShadow);
            } else if (uid.equals((Object)this.maricultureKelpId)) {
                blockMD.addFlags(BlockMD.Flag.Plant);
                blockMD.setTextureSide(2);
            } else if (uid.equals((Object)this.thaumcraftLeavesId)) {
                blockMD.addFlags(BlockMD.Flag.NoTopo, BlockMD.Flag.Foliage);
            }
            return false;
        }

        @Override
        public BlockMD handleBlock(ChunkMD chunkMD, BlockMD blockMD, int localX, int y, int localZ) {
            return blockMD;
        }
    }
}

