/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.bucket;

import com.stal111.forbidden_arcanus.common.item.bucket.BucketFamily;
import com.stal111.forbidden_arcanus.core.init.ModDataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public interface CapacityBucket {
    public int getCapacity();

    public BucketFamily getFamily();

    default public Item getEmptyBucket() {
        return this.getFamily().fluidBuckets().get(Fluids.EMPTY).get();
    }

    @Nullable
    default public Item getFilledBucket(Fluid fluid) {
        if (!this.getFamily().fluidBuckets().containsKey(fluid)) {
            return null;
        }
        return this.getFamily().fluidBuckets().get(fluid).get();
    }

    default public Item getMilkBucket() {
        return this.getFamily().milkBucket().get();
    }

    default public int getFullness(ItemStack stack) {
        return Math.max(1, (Integer)stack.getOrDefault(ModDataComponents.STORED_FLUID_AMOUNT, (Object)1));
    }

    default public ItemStack setFullness(ItemStack stack, int fullness) {
        if (fullness <= 0) {
            return this.getEmptyBucket().getDefaultInstance();
        }
        stack.set(ModDataComponents.STORED_FLUID_AMOUNT, (Object)Mth.clamp((int)fullness, (int)1, (int)this.getCapacity()));
        return stack;
    }

    default public boolean isFull(ItemStack stack) {
        if (this.getCapacity() == 0) {
            return false;
        }
        return this.getFullness(stack) >= this.getCapacity();
    }
}

