/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import com.stal111.forbidden_arcanus.common.essence.EssenceProvider;
import com.stal111.forbidden_arcanus.common.item.component.StoredEntity;
import com.stal111.forbidden_arcanus.core.init.ModDataComponents;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class QuantumCatcherItem
extends Item {
    private final TagKey<EntityType<?>> blacklistedEntities;

    public QuantumCatcherItem(TagKey<EntityType<?>> blacklistedEntities, Item.Properties properties) {
        super(properties);
        this.blacklistedEntities = blacklistedEntities;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        return QuantumCatcherItem.getData(stack).map(storedEntity -> {
            Level level = context.getLevel();
            if (!level.isClientSide() && !this.summonEntity((StoredEntity)storedEntity, context)) {
                return InteractionResult.FAIL;
            }
            QuantumCatcherItem.playSound(level, context.getPlayer(), context.getClickedPos(), false);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }).orElse(super.useOn(context));
    }

    private boolean summonEntity(StoredEntity storedEntity, UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Entity entity = storedEntity.createEntity(level);
        if (!level.getBlockState(pos).canBeReplaced(new BlockPlaceContext(context))) {
            pos = pos.relative(context.getClickedFace());
        }
        if (entity == null || !level.getBlockState(pos).canBeReplaced(new BlockPlaceContext(context))) {
            return false;
        }
        entity.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        if (context.getPlayer() != null) {
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, context.getPlayer().position());
        }
        level.addFreshEntity(entity);
        context.getItemInHand().remove(ModDataComponents.STORED_ENTITY);
        return true;
    }

    public InteractionResult onEntityInteract(ItemStack stack, Player player, LivingEntity target) {
        Level level = player.getCommandSenderWorld();
        int cost = QuantumCatcherItem.calculateAurealCost(target);
        EssenceProvider essenceProvider = EssenceHelper.getEssenceProvider((LivingEntity)player).orElseThrow();
        if (!this.isValidEntity(target) || QuantumCatcherItem.getData(stack).isPresent()) {
            return InteractionResult.PASS;
        }
        if (essenceProvider.getAmount(EssenceType.AUREAL) < cost) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide()) {
            if (stack.getCount() == 1) {
                stack.set(ModDataComponents.STORED_ENTITY, (Object)StoredEntity.of(target));
            } else {
                stack.consume(1, (LivingEntity)player);
                stack = new ItemStack((ItemLike)ModItems.QUANTUM_CATCHER.get());
                stack.set(ModDataComponents.STORED_ENTITY, (Object)StoredEntity.of(target));
                if (!player.addItem(stack)) {
                    player.drop(stack, false);
                }
            }
            target.discard();
            essenceProvider.updateAmount(EssenceType.AUREAL, amount -> amount - cost);
        }
        QuantumCatcherItem.playSound(level, player, target.blockPosition(), true);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public boolean isValidEntity(LivingEntity entity) {
        return !entity.getType().is(this.blacklistedEntities) && entity.isAlive();
    }

    public static int calculateAurealCost(LivingEntity entity) {
        int health = Math.round(entity.getMaxHealth());
        health = entity.getType().getCategory().isFriendly() ? (health >>= 1) : (int)((float)health * 1.1f);
        return health;
    }

    private static void playSound(Level level, @Nullable Player player, BlockPos pos, boolean release) {
        BlockPos soundPos = player == null ? pos : player.blockPosition();
        level.playSound(player, (double)soundPos.getX() + 0.5, (double)soundPos.getY() + 0.5, (double)soundPos.getZ() + 0.5, release ? (SoundEvent)ModSounds.QUANTUM_CATCHER_RELEASE.get() : (SoundEvent)ModSounds.QUANTUM_CATCHER_PICK_UP.get(), SoundSource.PLAYERS, 0.75f, level.getRandom().nextFloat() * 0.15f + 0.9f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        stack.addToTooltip(ModDataComponents.STORED_ENTITY, context, components::add, flag);
    }

    private static Optional<StoredEntity> getData(ItemStack stack) {
        return Optional.ofNullable((StoredEntity)stack.get(ModDataComponents.STORED_ENTITY));
    }
}

