/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.common.block.MagicalFarmlandBlock;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.valhelsia.valhelsia_core.api.common.util.ItemStackUtils;

public class ArcaneBoneMealItem
extends BoneMealItem {
    public ArcaneBoneMealItem(Item.Properties builder) {
        super(builder);
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockPos offsetPos = pos.relative(context.getClickedFace());
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (state.is(Blocks.FARMLAND)) {
            level.setBlockAndUpdate(pos, (BlockState)((MagicalFarmlandBlock)((Object)ModBlocks.MAGICAL_FARMLAND.get())).defaultBlockState().setValue((Property)BlockStateProperties.MOISTURE, (Comparable)((Integer)state.getValue((Property)BlockStateProperties.MOISTURE))));
            level.levelEvent(player, 2001, pos, Block.getId((BlockState)state));
            ItemStackUtils.shrinkStack((Player)player, (ItemStack)stack);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (ArcaneBoneMealItem.applyBoneMeal(stack, level, pos, player)) {
            if (!level.isClientSide()) {
                level.levelEvent(2005, pos, 0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        boolean flag = state.isFaceSturdy((BlockGetter)level, pos, context.getClickedFace());
        if (flag && ArcaneBoneMealItem.growWaterPlant((ItemStack)stack, (Level)level, (BlockPos)offsetPos, (Direction)context.getClickedFace())) {
            if (!level.isClientSide()) {
                level.levelEvent(2005, offsetPos, 0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public static boolean applyBoneMeal(ItemStack stack, Level level, BlockPos pos, @Nullable Player player) {
        BonemealEvent event = EventHooks.fireBonemealEvent((Player)player, (Level)level, (BlockPos)pos, (BlockState)level.getBlockState(pos), (ItemStack)stack);
        if (event.isCanceled()) {
            return event.isSuccessful();
        }
        if (ArcaneBoneMealItem.canGrow(level, pos)) {
            ArcaneBoneMealItem.grow(level, pos);
            stack.shrink(1);
            return true;
        }
        return false;
    }

    private static boolean canGrow(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof BonemealableBlock) {
            return ((BonemealableBlock)state.getBlock()).isValidBonemealTarget((LevelReader)world, pos, state);
        }
        return false;
    }

    private static void grow(Level world, BlockPos pos) {
        if (world.isClientSide()) {
            return;
        }
        for (int i = 0; i < 1000; ++i) {
            if (!ArcaneBoneMealItem.canGrow(world, pos) || world.isClientSide()) {
                return;
            }
            ((BonemealableBlock)world.getBlockState(pos).getBlock()).performBonemeal((ServerLevel)world, world.random, pos, world.getBlockState(pos));
        }
    }
}

