/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.essence;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.essence.EssenceData;
import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import com.stal111.forbidden_arcanus.core.init.ModDataComponents;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.NotNull;

public record EssenceStorage(EssenceData data, int limit, boolean showInTooltip) implements TooltipProvider
{
    public static final EssenceStorage EMPTY = new EssenceStorage(EssenceData.EMPTY, 0, true);
    public static final Codec<EssenceStorage> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EssenceData.CODEC.fieldOf("data").forGetter(EssenceStorage::data), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("limit").forGetter(EssenceStorage::limit), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(EssenceStorage::showInTooltip)).apply((Applicative)instance, EssenceStorage::new));
    public static final Codec<EssenceStorage> CODEC = Codec.withAlternative(FULL_CODEC, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)EssenceData.CODEC.fieldOf("data").forGetter(EssenceStorage::data), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("limit").forGetter(EssenceStorage::limit)).apply((Applicative)instance, (data, limit) -> new EssenceStorage((EssenceData)data, (int)limit, true))));
    public static final StreamCodec<FriendlyByteBuf, EssenceStorage> STREAM_CODEC = StreamCodec.composite(EssenceData.STREAM_CODEC, EssenceStorage::data, (StreamCodec)ByteBufCodecs.INT, EssenceStorage::limit, (StreamCodec)ByteBufCodecs.BOOL, EssenceStorage::showInTooltip, EssenceStorage::new);

    public static Codec<EssenceStorage> codec(EssenceType type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("amount").forGetter(storage -> storage.data.amount()), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("limit").forGetter(EssenceStorage::limit)).apply((Applicative)instance, (amount, limit1) -> new EssenceStorage(EssenceData.of(type, amount), (int)limit1, true)));
    }

    public static EssenceStorage createEmpty(EssenceType type, int limit) {
        return new EssenceStorage(EssenceData.of(type, 0), limit, true);
    }

    public float getFillPercentage() {
        return (float)this.data.amount() / (float)this.limit;
    }

    public void addToTooltip(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull Consumer<Component> consumer, @NotNull TooltipFlag flag) {
        consumer.accept((Component)Component.literal((String)(": " + this.data.amount() + "/" + this.limit)).withStyle(ChatFormatting.GRAY));
    }

    public void addEssence(ItemStack stack, int amount) {
        EssenceHelper.getEssenceStorage(stack).ifPresent(storage -> stack.set(ModDataComponents.ESSENCE_STORAGE, (Object)new EssenceStorage(EssenceData.of(storage.data.type(), Math.min(storage.data.amount() + amount, storage.limit())), storage.limit(), storage.showInTooltip())));
    }

    public boolean isFull() {
        return this.data.amount() >= this.limit;
    }

    public boolean isEmpty() {
        return this.data.amount() <= 0;
    }
}

