/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import net.minecraft.core.Holder;

public class ActiveRitualData {
    public static final Codec<ActiveRitualData> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Ritual.CODEC.fieldOf("ritual").forGetter(data -> data.ritual), (App)Codec.INT.fieldOf("counter").forGetter(data -> data.counter), (App)Codec.INT.fieldOf("lightning_counter").forGetter(data -> data.lightningCounter)).apply((Applicative)instance, ActiveRitualData::new));
    private final Holder<Ritual> ritual;
    private int counter;
    private int lightningCounter;

    public ActiveRitualData(Holder<Ritual> ritual, int counter, int lightningCounter) {
        this.ritual = ritual;
        this.counter = counter;
        this.lightningCounter = lightningCounter;
    }

    public static ActiveRitualData create(Holder<Ritual> ritual) {
        return new ActiveRitualData(ritual, 0, 0);
    }

    public float calculateRitualProgress() {
        return (float)this.counter / (float)((Ritual)this.ritual.value()).duration();
    }

    public Ritual getRitual() {
        return (Ritual)this.ritual.value();
    }

    public int getCounter() {
        return this.counter;
    }

    public void incrementCounter() {
        ++this.counter;
    }

    public int getLightningCounter() {
        return this.lightningCounter;
    }

    public void incrementLightningCounter() {
        ++this.lightningCounter;
    }
}

