/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.block.ModBlockPatterns;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeLevel;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.item.RitualStarterItem;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;
import org.jetbrains.annotations.Nullable;

public class HephaestusForgeBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    private static final String DESCRIPTION_ID = Util.makeDescriptionId((String)"block", (ResourceLocation)ForbiddenArcanus.location("hephaestus_forge"));
    private static final String TIER_ID = Util.makeDescriptionId((String)"block", (ResourceLocation)ForbiddenArcanus.location("hephaestus_forge.tier"));
    public static final BooleanProperty ACTIVATED = ModBlockStateProperties.ACTIVATED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)VoxelShapeHelper.combineAll((VoxelShape[])new VoxelShape[]{HephaestusForgeBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), HephaestusForgeBlock.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), HephaestusForgeBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), HephaestusForgeBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}), (VoxelShape)VoxelShapeHelper.combineAll((VoxelShape[])new VoxelShape[]{HephaestusForgeBlock.box((double)0.0, (double)15.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), HephaestusForgeBlock.box((double)3.0, (double)15.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0)}), (BooleanOp)BooleanOp.ONLY_FIRST);
    private final HephaestusForgeLevel level;

    public HephaestusForgeBlock(HephaestusForgeLevel level, BlockBehaviour.Properties properties) {
        super(properties);
        this.level = level;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new HephaestusForgeBlockEntity(pos, state);
    }

    public String getDescriptionId() {
        return DESCRIPTION_ID;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        components.add((Component)Component.translatable((String)TIER_ID, (Object[])new Object[]{this.level.getAsInt()}).withStyle(ChatFormatting.GRAY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        level.getBlockEntity(pos, (BlockEntityType)ModBlockEntities.HEPHAESTUS_FORGE.get()).ifPresent(blockEntity -> blockEntity.setForgeLevel(this.level));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        this.updateState(state, level, pos);
        if (((Boolean)state.getValue((Property)ACTIVATED)).booleanValue()) {
            BlockEntity blockEntity;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof HephaestusForgeBlockEntity) {
                HephaestusForgeBlockEntity blockEntity2 = (HephaestusForgeBlockEntity)blockEntity;
                player.openMenu((MenuProvider)blockEntity2);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, result);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        Item item;
        this.updateState(state, level, pos);
        if (((Boolean)state.getValue((Property)ACTIVATED)).booleanValue() && (item = stack.getItem()) instanceof RitualStarterItem) {
            BlockEntity blockEntity;
            RitualStarterItem ritualStarterItem = (RitualStarterItem)item;
            if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof HephaestusForgeBlockEntity) {
                HephaestusForgeBlockEntity blockEntity2 = (HephaestusForgeBlockEntity)blockEntity;
                ritualStarterItem.tryStartRitual(blockEntity2, level, stack, player);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, result);
    }

    public void updateState(BlockState state, Level level, BlockPos pos) {
        BlockPattern.BlockPatternMatch patternHelper = ModBlockPatterns.BASE_HEPHAESTUS_PATTERN.find((LevelReader)level, pos.below());
        if (patternHelper == null) {
            if (((Boolean)state.getValue((Property)ACTIVATED)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
            }
        } else if (!((Boolean)state.getValue((Property)ACTIVATED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide()) {
            return BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.HEPHAESTUS_FORGE.get()), HephaestusForgeBlockEntity::clientTick);
        }
        return BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.HEPHAESTUS_FORGE.get()), HephaestusForgeBlockEntity::serverTick);
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        super.triggerEvent(state, level, pos, id, param);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(id, param);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (newState.getBlock() instanceof HephaestusForgeBlock) {
            return;
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public HephaestusForgeLevel getLevel() {
        return this.level;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ACTIVATED, WATERLOGGED});
    }
}

