/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GoldenOrchidBlock
extends CropBlock {
    public static final IntegerProperty AGE = ModBlockStateProperties.AGE_6;
    private static final int MAX_AGE = 6;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)13.0, (double)6.0, (double)13.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)14.0, (double)7.0, (double)14.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)15.0, (double)9.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)15.0, (double)10.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0)};

    public GoldenOrchidBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Vec3 vec3 = state.getOffset(level, pos);
        return SHAPES[(Integer)state.getValue((Property)AGE)].move(vec3.x, vec3.y, vec3.z);
    }

    @Nonnull
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 6;
    }

    @Nonnull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)ModItems.GOLDEN_ORCHID_SEEDS.get();
    }

    protected boolean mayPlaceOn(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return state.is((Block)ModBlocks.MAGICAL_FARMLAND.get());
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        BlockPos below = pos.below();
        return (level.getRawBrightness(pos, 0) >= 8 || level.canSeeSky(pos)) && this.mayPlaceOn(level.getBlockState(below), (BlockGetter)level, below);
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }
}

