/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.gui.screen;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.residue.ResidueType;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.apache.commons.lang3.BooleanUtils;

public class ClibanoScreen
extends AbstractContainerScreen<ClibanoMenu> {
    private static final ResourceLocation TEXTURES = ForbiddenArcanus.location("textures/gui/container/clibano_combustion.png");

    public ClibanoScreen(ClibanoMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageHeight += 7;
        this.titleLabelY -= 2;
        this.inventoryLabelY += 9;
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int ySize;
        int xSize;
        guiGraphics.blit(TEXTURES, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        boolean isDoubleRecipe = ((ClibanoMenu)this.menu).isDoubleRecipe();
        if ((Integer)((ClibanoMenu)this.menu).getCookingDuration().getFirst() != 0) {
            xSize = Math.toIntExact(Math.round(22.0f * (float)((Integer)((ClibanoMenu)this.menu).getCookingProgress().getFirst()).intValue() / (float)((Integer)((ClibanoMenu)this.menu).getCookingDuration().getFirst()).intValue()));
            guiGraphics.blit(TEXTURES, this.getGuiLeft() + 83, this.getGuiTop() + 34 + BooleanUtils.toInteger((boolean)isDoubleRecipe), 176, 32, xSize, 7);
        }
        if ((Integer)((ClibanoMenu)this.menu).getCookingDuration().getSecond() != 0) {
            xSize = Math.toIntExact(Math.round(22.0f * (float)((Integer)((ClibanoMenu)this.menu).getCookingProgress().getSecond()).intValue() / (float)((Integer)((ClibanoMenu)this.menu).getCookingDuration().getSecond()).intValue()));
            guiGraphics.blit(TEXTURES, this.getGuiLeft() + 83, this.getGuiTop() + 43 - BooleanUtils.toInteger((boolean)isDoubleRecipe), 176, 41, xSize, 7);
        }
        if (((ClibanoMenu)this.menu).isSoulActive()) {
            ySize = Math.toIntExact(Math.round(18.0f * (float)((ClibanoMenu)this.menu).getSoulDuration() / 2700.0f));
            guiGraphics.blit(TEXTURES, this.getGuiLeft() + 52, this.getGuiTop() + 38 + 18 - ySize, 233, 18 - ySize, 18, ySize);
        }
        if (((ClibanoMenu)this.menu).getBurnTime() != 0) {
            ySize = Math.toIntExact(Math.round(15.0f * (float)((ClibanoMenu)this.menu).getBurnTime() / (float)((ClibanoMenu)this.menu).getBurnDuration()));
            int uOffset = 179 + 19 * ((ClibanoMenu)this.menu).getFireType();
            guiGraphics.blit(TEXTURES, this.getGuiLeft() + 55, this.getGuiTop() + 39 + 15 - ySize, uOffset, 16 - ySize, 12, ySize);
        }
        if (((ClibanoMenu)this.menu).getResidueFullness() != 0) {
            xSize = Math.toIntExact(Math.round(26.0f * (float)((ClibanoMenu)this.menu).getResidueFullness() / 64.0f));
            guiGraphics.blit(TEXTURES, this.getGuiLeft() + 111, this.getGuiTop() + 58, 179, 21, xSize, 7);
        }
    }

    protected void renderTooltip(@Nonnull GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        int posX = x - this.getGuiLeft();
        int posY = y - this.getGuiTop();
        if (posY >= 58 && posY <= 64 && posX >= 111 && posX <= 136) {
            List textComponents = (List)Util.make(new ArrayList(), list -> {
                list.add(Component.translatable((String)"gui.forbidden_arcanus.clibano.residue_fullness").append(": " + ((ClibanoMenu)this.menu).getResidueFullness() + "/64"));
                list.add(Component.empty());
            });
            ((ClibanoMenu)this.menu).getResidueData().forEach((residueType, integer) -> {
                if (integer == 0) {
                    return;
                }
                textComponents.add(((ResidueType)residueType.value()).name().copy().append(": " + integer));
            });
            if (textComponents.size() == 2) {
                textComponents.remove(1);
            }
            guiGraphics.renderTooltip(this.font, textComponents, Optional.empty(), x, y);
        }
    }
}

